% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-filter_on.R
\name{filter_on}
\alias{filter_on}
\title{Filter with secondary indices}
\usage{
filter_on(.data, ..., nomatch = getOption("datatable.nomatch"),
  mult = "all", .negate = FALSE,
  .chain = getOption("table.express.chain", TRUE))
}
\arguments{
\item{.data}{An instance of \link{ExprBuilder}.}

\item{...}{Key-value pairs, see details.}

\item{nomatch, mult}{See \link[data.table:data.table]{data.table::data.table}.}

\item{.negate}{Whether to negate the expression and search only for rows that don't contain the
given values.}

\item{.chain}{Logical. Should a new frame be automatically chained to the expression if the
clause being set already exists?}
}
\description{
Helper to filter specifying the \code{on} part of the \link[data.table:data.table]{data.table::data.table} query.
}
\details{
The key-value pairs in '...' are processed as follows:
\itemize{
\item The names are used as \code{on} in the \code{data.table} frame.
\item The values are packed in a list and used as \code{i} in the \code{data.table} frame.
}

Thus, all pairs \strong{must} be named.

To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
\examples{

data("mtcars")

data.table::as.data.table(mtcars) \%>\%
    start_expr \%>\%
    filter_on(cyl = 4, gear = 5)

}
