% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttheme_awesome.R
\name{ttheme_awesome}
\alias{ttheme_awesome}
\title{Define theme for awesome table plot.}
\usage{
ttheme_awesome(
  base_size = 8,
  base_colour = "black",
  base_family = "",
  core_size = 10,
  scale_breaks = 10,
  scale_ratio = 0.25,
  color_palette = "black",
  color_breaks = NULL,
  rep_mode = "col",
  parse = FALSE,
  size_unit = "mm",
  padding = c(0.3, 0.3),
  show_legend = TRUE,
  legend_position = NULL,
  legend_layout = NULL,
  legend_x = NULL,
  legend_y = NULL,
  legend_width = NULL,
  legend_height = NULL,
  legend_scale = 1.5,
  legend_title_fontsize = 12,
  legend_labels_fontsize = 10,
  legend_labels_pad = -1.2,
  ...
)
}
\arguments{
\item{base_size}{default font size}

\item{base_colour}{default font colour}

\item{base_family}{default font family}

\item{core_size}{cell size for core background grobs}

\item{scale_breaks}{number of size categories for core foreground grobs or numeric vector of bin breaks}

\item{scale_ratio}{ratio of minimum to maximum core foreground grobs sizes}

\item{color_palette}{color palette for core foreground grobs}

\item{color_breaks}{bin breaks for color palette for core foreground grobs}

\item{rep_mode}{'col' or 'row'. Used when recycling fg_params or bg_params to make a matrix of params.}

\item{parse}{logical, default behaviour for parsing text as plotmath}

\item{size_unit}{character vector defining the unit used for sizes. See \code{grid::unit} for all possible
specifications.}

\item{padding}{length-2 vector specifying the horizontal and vertical padding of text within each cell}

\item{show_legend}{(optional) set to FALSE to not draw any legend.}

\item{legend_position}{(optional) choose between 'top_left', 'top_center' and 'top_right'.}

\item{legend_layout}{(optional) Only 'columnwise' is supported for now.}

\item{legend_x}{(optional) x position in 'npc' units of the left bottom corner of the viewport defining the scale
legend. If NULL, the function will try to set it automatically using legend_position.}

\item{legend_y}{(optional) y position in 'npc' units of the left bottom corner of the viewport defining the scale
legend. If NULL, the function will try to set it automatically.}

\item{legend_width}{(optional) width in 'npc' units of the viewport(s) defining legend(s).
If NULL, the function will try to set it automatically.}

\item{legend_height}{(optional) height in 'npc' units of the viewport(s) defining legend(s).
If NULL, the function will try to set it automatically.}

\item{legend_scale}{(optional) Scale factor that defines the size of the legend colorbar cells relatively to the
main plot cells.}

\item{legend_title_fontsize}{(optional) if NULL, font size is set to \code{theme$colhead$fontsize}.}

\item{legend_labels_fontsize}{(optional) if NULL, font size is set to \code{theme$colhead$fontsize}.}

\item{legend_labels_pad}{(optional) padding between the legend labels.}

\item{...}{extra parameters added to the theme list}
}
\value{
a list of lists with each sublist defining parameters for the corresponding part of the plot. The parts are
\itemize{
\item \strong{core}:  defines all graphical parameters for the grobs sizes, shapes and background of the table.
\item \strong{colhead}:  defines all graphical parameters for the table column labels.
\item \strong{colmore}:  defines all graphical parameters for the additional column descriptors.
\item \strong{rowhead}:  defines all graphical parameters for the table row labels.
\item \strong{rowmore}:  defines all graphical parameters for the additional row descriptors.
\item \strong{legend}:  defines all graphical parameters for the legend.
}
}
\description{
Define theme for awesome table plot.
}
\author{
Yoann Pradat
}
