% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.svyCatTable.R
\name{print.svyCatTable}
\alias{print.svyCatTable}
\title{Format and print \code{svyCatTable} class objects}
\usage{
\method{print}{svyCatTable}(x, digits = 1, pDigits = 3, quote = FALSE,
  missing = FALSE, explain = TRUE, printToggle = TRUE, noSpaces = FALSE,
  format = c("fp", "f", "p", "pf")[1], showAllLevels = FALSE,
  cramVars = NULL, dropEqual = FALSE, test = TRUE, exact = NULL,
  smd = FALSE, CrossTable = FALSE, ...)
}
\arguments{
\item{x}{The result of a call to the \code{\link{svyCreateCatTable}} function.}

\item{digits}{Number of digits to print in the table.}

\item{pDigits}{Number of digits to print for p-values (also used for standardized mean differences).}

\item{quote}{Whether to show everything in quotes. The default is FALSE. If TRUE, everything including the row and column names are quoted so that you can copy it to Excel easily.}

\item{missing}{Whether to show missing data information.}

\item{explain}{Whether to add explanation to the variable names, i.e., (\%) is added to the variable names when percentage is shown.}

\item{printToggle}{Whether to print the output. If FALSE, no output is created, and a matrix is invisibly returned.}

\item{noSpaces}{Whether to remove spaces added for alignment. Use this option if you prefer to align numbers yourself in other software.}

\item{format}{The default is "fp" frequency (percentage). You can also choose from "f" frequency only, "p" percentage only, and "pf" percentage (frequency).}

\item{showAllLevels}{Whether to show all levels. FALSE by default, i.e., for 2-level categorical variables, only the higher level is shown to avoid redundant information.}

\item{cramVars}{A character vector to specify the two-level categorical variables, for which both levels should be shown in one row.}

\item{dropEqual}{Whether to drop " = second level name" description indicating which level is shown for two-level categorical variables.}

\item{test}{Whether to show p-values. TRUE by default. If FALSE, only the numerical summaries are shown.}

\item{exact}{This option is not available for tables from weighted data.}

\item{smd}{Whether to show standardized mean differences. FALSE by default. If there are more than one contrasts, the average of all possible standardized mean differences is shown. For individual contrasts, use \code{summary}.}

\item{CrossTable}{Whether to show the cross table objects held internally using gmodels::CrossTable function. This will give an output similar to the PROC FREQ in SAS.}

\item{...}{For compatibility with generic. Ignored.}
}
\value{
A matrix object containing what you see is also invisibly returned. This can be assinged a name and exported via \code{write.csv}.
}
\description{
\code{print} method for the \code{svyCatTable} class objects created by \code{\link{svyCreateCatTable}} function.
}
\examples{

## See the examples for svyCreateTableOne()

}
\seealso{
\code{\link{svyCreateTableOne}}, \code{\link{svyCreateCatTable}}, \code{\link{summary.svyCatTable}}
}
\author{
Kazuki Yoshida
}
