% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notes.R
\name{note-metadata}
\alias{note-metadata}
\alias{n_steps}
\alias{n_notes}
\alias{n_chords}
\alias{n_octaves}
\alias{tally_notes}
\alias{tally_pitches}
\alias{tally_octaves}
\alias{distinct_notes}
\alias{distinct_pitches}
\alias{distinct_octaves}
\alias{pitch_range}
\alias{semitone_range}
\alias{semitone_span}
\alias{octave_range}
\alias{octave_span}
\alias{octave_type}
\alias{accidental_type}
\alias{time_format}
\alias{is_space_time}
\alias{is_vector_time}
\title{Noteworthy string metadata}
\usage{
n_steps(notes)

n_notes(notes)

n_chords(notes)

n_octaves(notes)

tally_notes(notes)

tally_pitches(notes)

tally_octaves(notes)

distinct_notes(notes)

distinct_pitches(notes)

distinct_octaves(notes)

pitch_range(notes)

semitone_range(notes)

semitone_span(notes)

octave_range(notes)

octave_span(notes)

octave_type(notes)

accidental_type(notes)

time_format(notes)

is_space_time(notes)

is_vector_time(notes)
}
\arguments{
\item{notes}{character, a noteworthy string, space-delimited or vector of
individual entries.}
}
\value{
integer or character
}
\description{
Inspect metadata for noteworthy strings.
}
\details{
Returned object depends on the nature of the function. It can be integers,
logical, character. Results can be a vector of equal length of a single
value summary.
\code{distinct_notes} and \code{distinct_pitches} filter a noteworthy string
to its unique elements, respectively. These functions return another
noteworthy string.

The \code{n_*} functions give summary totals of the number of timesteps,
number of individual note (non-chord) timesteps, number of chord time
steps, and the number of distinct octaves present across timesteps.
Use the \code{tally_*} and \code{distinct_*} functions specifically for
summaries of unique elements.

\code{*_span} functions are just the size of a range, e.g.,
\code{semitone_range} and \code{semitone_span}.

Functions pertaining to type or format of a noteworthy string provide
information on how a particular string is defined, e.g. \code{time_format}.
}
\examples{
x <- "e_2 a_, c#f#a#"
n_steps(x)
n_notes(x)
n_chords(x)
n_octaves(x)

tally_notes(x)
tally_pitches(x)
tally_octaves(x)
distinct_notes(x)
distinct_pitches(x)
distinct_octaves(x)

pitch_range(x)
semitone_range(x)
semitone_span(x)
octave_range(x)
octave_span(x)

octave_type(x)
accidental_type(x)
time_format(x)
is_space_time(x)
is_vector_time(x)
}
