% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot-matrix.R
\docType{methods}
\name{plot_matrix}
\alias{plot_matrix}
\alias{matrigraphe}
\alias{plot_heatmap}
\alias{plot_heatmap-method}
\alias{plot_heatmap,CountMatrix-method}
\alias{plot_heatmap,FrequencyMatrix-method}
\alias{plot_heatmap,IncidenceMatrix-method}
\title{Heatmap}
\usage{
plot_heatmap(object, ...)

\S4method{plot_heatmap}{CountMatrix}(object, PVI = FALSE,
  frequency = TRUE)

\S4method{plot_heatmap}{FrequencyMatrix}(object)

\S4method{plot_heatmap}{IncidenceMatrix}(object)
}
\arguments{
\item{object}{An object to be plotted.}

\item{...}{Further arguments to be passed to internal methods.}

\item{PVI}{A \code{\link{logical}} scalar: should the PVI be drawn instead of
frequencies (see details)?}

\item{frequency}{A \code{\link{logical}} scalar: should relative frequencies
be drawn? If \code{FALSE}, raw data are plotted.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plots a heatmap.
}
\details{
If \code{PVI} is \code{FALSE}, it plots a heatmap of relative abundances
 (frequency), otherwise percentages of the independence value are drawn (in
 french, "pourcentages de valeur d'indépendance", PVI).

 \code{PVI} is calculated for each cell as the percentage to the column
 theoretical independence value: \code{PVI} greater than \eqn{1} represent
 positive deviations from the independence, whereas \code{PVI} smaller than
 \eqn{1} represent negative deviations (Desachy 2004).

 The \code{PVI} matrix allows to explore deviations from independence
 (an intuitive graphical approach to \eqn{\chi^2}{Chi-squared}),
 in such a way that a high-contrast matrix has quite significant deviations,
 with a low risk of being due to randomness (Desachy 2004).
}
\examples{
## Abundance data
## Coerce dataset to a count matrix (data from Desachy 2004)
compiegne_count <- as_count(compiegne)

## Plot matrix diagram...
## ...without threshod (i.e. heatmap)
plot_heatmap(compiegne_count)
## ...with PVI as threshold (i.e. Bruno Desachy's matrigraphe)
plot_heatmap(compiegne_count, PVI = TRUE) +
  ggplot2::scale_fill_gradient2(midpoint = 1)

## Presence/absence data
bin <- IncidenceMatrix(data = sample(0:1, size = 100, replace = TRUE),
                       nrow = 10, ncol = 10)
plot_heatmap(bin) +
  ggplot2::scale_fill_manual(values = c("TRUE" = "black", "FALSE" = "white"))
}
\references{
Desachy, B. (2004). Le sériographe EPPM: un outil informatisé de sériation
 graphique pour tableaux de comptages. \emph{Revue archéologique de
 Picardie}, 3(1), 39-56.
 DOI: \href{https://doi.org/10.3406/pica.2004.2396}{10.3406/pica.2004.2396}.
}
\seealso{
Other plot: \code{\link{plot_bar}},
  \code{\link{plot_date}}, \code{\link{plot_line}},
  \code{\link{plot_spot}}
}
\author{
N. Frerebeau
}
\concept{plot}
