% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity_alpha.R
\docType{methods}
\name{index_ace}
\alias{index_ace}
\alias{index_ace-method}
\alias{index_ace,numeric-method}
\title{Abundance-based Coverage Estimator}
\usage{
index_ace(x, ...)

\S4method{index_ace}{numeric}(x, k = 10, na.rm = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link{numeric}} vector of count data (absolute frequencies).}

\item{...}{Currently not used.}

\item{k}{A length-one \code{\link{numeric}} vector giving the threshold between
rare/infrequent and abundant/frequent species.}

\item{na.rm}{A \code{\link{numeric}} scalar: should missing values (including \code{NaN}) be
removed?}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Abundance-based Coverage Estimator
}
\references{
Chao, A. & Lee, S.-M. (1992). Estimating the Number of Classes via Sample
Coverage. \emph{Journal of the American Statistical Association}, 87(417),
210-217. \doi{10.1080/01621459.1992.10475194}.
}
\seealso{
Other alpha diversity measures: 
\code{\link{index_baxter}()},
\code{\link{index_berger}()},
\code{\link{index_boone}()},
\code{\link{index_brillouin}()},
\code{\link{index_chao1}()},
\code{\link{index_chao2}()},
\code{\link{index_hurlbert}()},
\code{\link{index_ice}()},
\code{\link{index_margalef}()},
\code{\link{index_mcintosh}()},
\code{\link{index_menhinick}()},
\code{\link{index_shannon}()},
\code{\link{index_simpson}()},
\code{\link{index_squares}()}
}
\author{
N. Frerebeau
}
\concept{alpha diversity measures}
