% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt_class.R
\name{fmt}
\alias{fmt}
\alias{is_fmt}
\alias{get_num}
\alias{set_num}
\alias{get_type}
\alias{set_type}
\alias{is_totrow}
\alias{as_totrow}
\alias{is_tottab}
\alias{as_tottab}
\alias{is_totcol}
\alias{as_totcol}
\alias{is_refrow}
\alias{as_refrow}
\alias{get_comp_all}
\alias{set_comp_all}
\alias{get_diff_type}
\alias{set_diff_type}
\alias{get_ci_type}
\alias{set_ci_type}
\alias{get_col_var}
\alias{set_col_var}
\alias{is_refcol}
\alias{as_refcol}
\alias{get_color}
\alias{set_color}
\alias{get_digits}
\alias{set_digits}
\title{Create a vector of class formatted numbers}
\usage{
fmt(
  n = integer(),
  type = "n",
  digits = rep(0L, length(n)),
  display = dplyr::case_when(type == "mean" ~ "mean", type \%in\% c("row", "col", "all",
    "all_tabs") ~ "pct", TRUE ~ "n"),
  wn = rep(NA_real_, length(n)),
  pct = rep(NA_real_, length(n)),
  mean = rep(NA_real_, length(n)),
  diff = rep(NA_real_, length(n)),
  ctr = rep(NA_real_, length(n)),
  var = rep(NA_real_, length(n)),
  ci = rep(NA_real_, length(n)),
  in_totrow = rep(FALSE, length(n)),
  in_tottab = rep(FALSE, length(n)),
  in_refrow = rep(FALSE, length(n)),
  comp_all = NA,
  diff_type = "",
  ci_type = "",
  col_var = "",
  totcol = FALSE,
  refcol = FALSE,
  color = ""
)

is_fmt(x)

get_num(x)

set_num(x, value)

get_type(x, ...)

set_type(x, type)

is_totrow(x, ...)

as_totrow(x, in_totrow = TRUE)

is_tottab(x, ...)

as_tottab(x, in_tottab = TRUE)

is_totcol(x, ...)

as_totcol(x, totcol = TRUE)

is_refrow(x, ...)

as_refrow(x, in_refrow = TRUE)

get_comp_all(x, replace_na = TRUE)

set_comp_all(x, comp_all = FALSE)

get_diff_type(x, ...)

set_diff_type(x, diff_type)

get_ci_type(x, ...)

set_ci_type(x, ci_type)

get_col_var(x, ...)

set_col_var(x, col_var)

is_refcol(x, ...)

as_refcol(x, refcol = TRUE)

get_color(x, ...)

set_color(x, color)

get_digits(x)

set_digits(x, value)
}
\arguments{
\item{n}{The underlying count, as an integer vector of length \code{n()}. It is used
to calculate confidence intervals.}

\item{type}{The type of the column, which defines the type of background calculation
to be made (as a single string, since it's not a field but an attribute) :
\itemize{
\item \code{"n"}: counts
\item \code{"mean"}: mean column (from numeric variables)
\item \code{"row"}: row percentages
\item \code{"col"}: column percentages
\item \code{"all"}: frequencies by subtable/group (i.e. by \code{tab_vars})
\item \code{"all_tabs"}: frequencies for the whole table
}}

\item{digits}{The number of digits, as an integer, or an integer vector the length
of \code{n}.}

\item{display}{The display type : the name of the field you want to show when printing
the vector. Among \code{"n"}, \code{"wn"}, \code{"pct"}, \code{"diff"}, \code{"ctr"},
\code{"mean"}, \code{"var"}, \code{"ci"},
\code{"pct_ci"} (percentages with visible confidence interval),
\code{"mean_ci"} (means with visible confidence interval). As a single string, or a
character vector the length of \code{n}.}

\item{wn}{The underlying weighted counts, as a double vector the length of
\code{n}. It is used in certain operations on \code{\link{fmt}}, like means.}

\item{pct}{The percentages, as a double vector the length of \code{n}.
Calculate with \code{\link{tab_pct}}.}

\item{mean}{The means, as a double vector the length of \code{n}.}

\item{diff}{The differences (from totals or first cells),
as a double vector the length of \code{n}. Used to set colors for means and
row or col percentages. Calculate with \code{\link{tab_pct}}.}

\item{ctr}{The contributions of cells to (sub)tables variances,
as a double vector the length of \code{n}. Used to print colors when
\code{color = "contrib"}. The mean contribution of each (sub)table is written on
total rows (then, colors don't print well without total rows).
Calculate with \code{\link{tab_chi2}}.}

\item{var}{The cells variances, as a double vector the length of \code{n}.
Used with \code{type = "mean"} to calculate confidence intervals.
Calculate with \code{tab_plain}.}

\item{ci}{The confidence intervals, as a double vector the length of \code{n}.
Used to print colors (\code{"diff_ci"}, \code{"after_ci"}).
Calculate with \code{tab_ci}.}

\item{in_totrow}{\code{TRUE} when the cell is part of a total row}

\item{in_tottab}{\code{TRUE} when the cell is part of a total table}

\item{in_refrow}{\code{TRUE} when the cell is part of a reference row
(cf. \code{diff_type})}

\item{comp_all}{\code{FALSE} when the comparison level is the subtable/group,
\code{TRUE} when it is the whole table}

\item{diff_type}{The type of difference of the vector (calculate
with \code{\link{tab_pct}}) :
\itemize{
\item \code{""} or \code{"no"}: no differences have been calculated
\item \code{"tot"}: the reference row (or column) is the total row (or column)
\item \code{"first"}: the reference row (or column) is the first row (or column)
}}

\item{ci_type}{The type of confidence intervals of the vector (calculate
with \code{\link{tab_ci}}) :
\itemize{
\item \code{""} or \code{"no"}: no ci have been calculated
\item \code{"cell"}: absolute confidence intervals of cells percentages.
\item \code{"diff"}: confidence intervals of the difference between a cell and the
relative total cell (or relative first cell when \code{diff_type = "first"}).
\item \code{"auto"}: \code{"diff"} for means and row/col percentages,
\code{"cell"} for frequencies ("all", "all_tabs").
}}

\item{col_var}{The name of the \code{col_var} used to calculate the vector}

\item{totcol}{\code{TRUE} when the vector is a total column}

\item{refcol}{\code{TRUE} when the vector is a reference column}

\item{color}{The type of color to print :
\itemize{
\item \code{"no"}: no colors are printed.
\item \code{"diff"}: color percentages and means based on cells differences from
totals (or from first cells when \code{diff = "first"}).
\item \code{"diff_ci"}: color pct and means based on cells differences from totals
or first cells, removing coloring when the confidence interval of this difference
is higher than the difference itself.
\item \code{"after_ci"}: idem, but cut off the confidence interval from the
difference first.
\item \code{"contrib"}: color cells based on their contribution to variance
(except mean columns, from numeric variables).
}}

\item{x}{The object to test, to get a field in, or to modify.}

\item{value}{The value you want to inject in some \code{fmt} vector's vctrs::field
or attribute using a given "set" function.}

\item{...}{Used in methods to add arguments in the future.}

\item{replace_na}{By default, \code{\link{get_comp_all}} takes NA in comparison level
to be a \code{FALSE} (=comparison at subtables/groups level). Set to \code{FALSE}
to avoid this behavior.}
}
\value{
A vector of class \code{tabxplor_fmt}.

A logical vector.

A double vector.

A modified fmt vector.

A character vector with the vectors type.

A modified fmt vector.

A logical vector with the fmt vectors totrow field.

A modified fmt vector with totrow field changed.

A logical vector with the fmt vectors tottab field.

A modified fmt vector with tottab field changed.

A logical vector with the fmt vectors totcol attribute.

A modified fmt vector with totcol attribute changed.

A logical vector with the fmt vectors in_refrow field

A modified fmt vector with in_refrom field changed.

A modified fmt vector with comp attribute changed.

A logical vector with the fmt vectors type attributes

A modified fmt vector.

A logical vector with the fmt vectors ci_type attributes

A modified fmt vector.

A logical vector with the fmt vectors col_var attributes

A modified fmt vector.

A logical vector with the fmt vectors is_refcol attributes

A modified fmt vector.

A logical vector with the fmt vectors color attributes

A modified fmt vector.
}
\description{
\code{fmt} vectors, of class \code{tabxplor_fmt}, powers \pkg{tabxplor}
and \code{\link{tab}} tibbles.
As a \code{\link[vctrs:new_rcrd]{record}}, they stores all data necessary to
calculate percentages, Chi2 metadata or confidence intervals, but also to format and
color the table to help the user read it. You can access this data with
\code{\link[vctrs:field]{vctrs::field}}, or change it with
\code{\link[vctrs:field]{vctrs:field<-}}. A \code{fmt} vector have 13 fields :
\code{n}, \code{digits}, \code{display}, \code{wn}, \code{pct}, \code{mean},
\code{diff}, \code{ctr}, \code{var}, \code{ci}, \code{in_totrow},  \code{in_tottab},
\code{in_refrow}. Other arguments are attributes, attached not to each value, but to
the whole vector, like \code{type}, \code{totcol} or \code{color}. You can get them
with \code{\link[base:attr]{attr}} and modify them with
\code{\link[base:attr]{attr<-}}. Special functions listed below are made to
facilitate programming with with \pkg{tabxplor} formatted numbers.
\code{taxplfmt} vectors can use all standard operations, like +, -, sum(), or c(),
using \pkg{vctrs}.
}
\section{Functions}{
\itemize{
\item \code{is_fmt()}: a test function for class fmt.

\item \code{get_num()}: get the currently displayed field

\item \code{set_num()}: set the currently displayed field (not changing display type)

\item \code{get_type()}: get types of fmt columns (at \code{fmt} level or \code{tab} level)

\item \code{set_type()}: set the column type attribute of a \code{fmt} vector

\item \code{is_totrow()}: test function to detect cells in total rows
(at \code{fmt} level or \code{tab} level)

\item \code{as_totrow()}: set the "in_totrow" field (belong to total row)

\item \code{is_tottab()}: test function to detect cells in total tables
(at \code{fmt} level or \code{tab} level)

\item \code{as_tottab()}: set the "in_tottab" field (belong to total table)

\item \code{is_totcol()}: test function for total columns
(at \code{fmt} level or \code{tab} level)

\item \code{as_totcol()}: set the "totcol" attribute of a \code{fmt} vector

\item \code{is_refrow()}: test function to detect cells in reference rows
(at \code{fmt} level or \code{tab} level)

\item \code{as_refrow()}: set the "in_refrow" field (belong to reference row)

\item \code{get_comp_all()}: get comparison level of fmt columns

\item \code{set_comp_all()}: set the comparison level attribute of a \code{fmt} vector

\item \code{get_diff_type()}: get differences type of fmt columns (at \code{fmt} level or \code{tab} level)

\item \code{set_diff_type()}: set the differences type attribute of a \code{fmt} vector

\item \code{get_ci_type()}: get confidence intervals type of fmt columns (at \code{fmt} level or \code{tab} level)

\item \code{set_ci_type()}: set the confidence intervals type attribute of a \code{fmt} vector

\item \code{get_col_var()}: get names of column variable of fmt columns (at \code{fmt} level or \code{tab} level)

\item \code{set_col_var()}: set the "col_var" attribute of a \code{fmt} vector

\item \code{is_refcol()}: test function for reference columns (at \code{fmt} level or \code{tab} level)

\item \code{as_refcol()}: set the "ref_col" attribute of a \code{fmt} vector

\item \code{get_color()}: get color (at \code{fmt} level or \code{tab} level)

\item \code{set_color()}: set the "color" attribute of a \code{fmt} vector

\item \code{get_digits()}: get the "digits" field

\item \code{set_digits()}: set the "digits" field

}}
\examples{
library(dplyr)

f <- fmt(n = c(7, 19, 2), type = "row", pct = c(0.25, 0.679, 0.07))
f

# To get the currently displayed field :
get_num(f)

# To modify the currently displayed field :
set_num(f, c(1, 0, 0))


# See all the underlying fields of a fmt vector (a data frame with a number of rows
#  equal to the length of the vector) :
vctrs::vec_data(f)

# To get the numbers of digits :
vctrs::field(f, "digits")
f$digits

# To get the count :
vctrs::field(f, "n")
f$n

# To get the display :
vctrs::field(f, "display")
f$display

# To modify a field, you can use `dplyr::mutate` on the fmt vector,
# referring to the names of the columns of the underlying data.frame (`vctrs::vec_data`) :
vctrs::`field<-`(f, "pct", c(1, 0, 0))
mutate(f, pct = c(1, 0, 0))

# See all the attributes of a fmt vector :
attributes(f)

# To modify the "type" attribute of a fmt vector :
set_type(f, "col")

# To modify the "color" attribute of a fmt vector :
set_color(f, "contrib")




tabs <- tab(starwars, sex, hair_color, gender, na = "drop", pct = "row",
            rare_to_other = TRUE, n_min = 5)

# To identify the total columns, and work with them :
is_totcol(tabs)
tabs \%>\% mutate(across(where(is_totcol), ~ "total column"))

# To identify the total rows, and work with them :
is_totrow(tabs)
tabs \%>\%
  mutate(across(
    where(is_fmt),
    ~ if_else(is_totrow(.), true = "into_total_row", false = "normal_cell")
  ))

# To identify the total tables, and work with them :
tottabs <- is_tottab(tabs)
tabs \%>\% tibble::add_column(tottabs) \%>\%
  mutate(total = if_else(tottabs, "part of a total table", "normal cell"))

# To access the displayed numbers, as numeric vectors :
tabs \%>\% mutate(across(where(is_fmt), get_num))

# To access the displayed numbers, as character vectors (without colors) :
tabs \%>\% mutate(across(where(is_fmt), format))

# To access the (non-displayed) differences of the cells percentages from totals :
tabs \%>\% mutate(across(where(is_fmt), ~ vctrs::field(., "diff")))


# To do more complex operations, like creating a new column with standard deviation and
# print it with 2 decimals, use `dplyr::mutate` on all the fmt columns of a table :

tab_num(forcats::gss_cat, race, c(age, tvhours), marital, digits = 1L, comp = "all") |>
  dplyr::mutate(dplyr::across( #Mutate over the whole table.
    c(age, tvhours),
    ~ dplyr::mutate(.,         #Mutate over each fmt vector's underlying data.frame.
                    var     = sqrt(var),
                    display = "var",
                    digits  = 2L) |>
      set_color("no"),
    .names = "{.col}_sd"
  ))
}
