% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tadaa_two_sample.R
\name{tadaa_wilcoxon}
\alias{tadaa_wilcoxon}
\title{Tadaa, Wilcoxon!}
\usage{
tadaa_wilcoxon(data, response, group, direction = "two.sided",
  paired = FALSE, print = c("df", "console", "html", "markdown"), ...)
}
\arguments{
\item{data}{A \code{data.frame}.}

\item{response}{The response variable (dependent).}

\item{group}{The group variable, usually a \code{factor}.}

\item{direction}{Test direction, like \code{alternative} in \link{t.test}.}

\item{paired}{If \code{TRUE}, a paired test is performed, defaults to \code{FALSE}.}

\item{print}{Print method, default \code{df}: A regular \code{data.frame}.
Otherwise passed to \link[pixiedust]{sprinkle_print_method} for fancyness.}

\item{...}{Further arguments passed to \link[stats]{wilcox.test}, e.g. \code{correct = FALSE}.}
}
\value{
A \code{data.frame} by default, otherwise \code{dust} object, depending on \code{print}.
}
\description{
Tadaa, Wilcoxon!
}
\examples{
set.seed(42)
df <- data.frame(x = runif(100), y = sample(c("A", "B"), 100, TRUE))
tadaa_wilcoxon(df, x, y)

df <- data.frame(x = runif(100), y = c(rep("A", 50), rep("B", 50)))
tadaa_wilcoxon(df, x, y, paired = TRUE)
}
\seealso{
Other Tadaa-functions: \code{\link{tadaa_aov}},
  \code{\link{tadaa_chisq}}, \code{\link{tadaa_kruskal}},
  \code{\link{tadaa_levene}}, \code{\link{tadaa_nom}},
  \code{\link{tadaa_normtest}},
  \code{\link{tadaa_one_sample}}, \code{\link{tadaa_ord}},
  \code{\link{tadaa_pairwise_gh}},
  \code{\link{tadaa_pairwise_tukey}},
  \code{\link{tadaa_pairwise_t}},
  \code{\link{tadaa_t.test}}
}
