% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rms.R
\name{summary_rms}
\alias{summary_rms}
\title{Combine information from summary.rms(), anova.rms(), and other rms object info to create a
single pretty table of model results. The rms and Hmisc packages are required.}
\usage{
summary_rms(rms.model, data.set = NULL, short.labels = NULL,
  footnote = NULL, rnd.digits = 2, rnd.stats = rnd.digits)
}
\arguments{
\item{rms.model}{Object of class rms, or list of named objects}

\item{data.set}{Data frame from which to get variable labels. Defaults to NULL, in which case
variable names will be used.}

\item{short.labels}{Named vector of variable labels to replace in interaction rows. Must be in
format c("variable name" = "shortened label").}

\item{footnote}{A string to add to the table as a footnote.}

\item{rnd.digits}{Number of digits to round reference, comparison, result and CI values to.
Defaults to 2.}

\item{rnd.stats}{Number of digits to round model LR, R2, etc to. Defaults to rnd.digits.}
}
\description{
Combine information from summary.rms(), anova.rms(), and other rms object info to create a
single pretty table of model results. The rms and Hmisc packages are required.
}
