% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\docType{class}
\name{Parser}
\alias{Parser}
\title{The parser class for generating abstract syntax trees for given table formulas.}
\format{\code{\link{R6Class}} object.}
\usage{
Parser
}
\description{
The parser class for generating abstract syntax trees for given table formulas.
}
\section{Fields}{

\describe{
\item{\code{input}}{Storage for input string of a formula}

\item{\code{pos}}{The current parsing position}

\item{\code{len}}{The length of the input}
}}

\section{Methods}{

\describe{
  \item{\code{new()}}{Create a parser.}
  \item{\code{expect(id)}}{Require the next token parsed to have the specified id and consume it.}
  \item{\code{peek()}}{Return the next token parsed without consuming it.}
  \item{\code{eat_whitespace()}}{Consume any spaces or tabs in input. }
  \item{\code{next_token()}}{Return the next token parsed and consume it.}
  \item{\code{format()}}{ Parse a format class and return it's string.}
  \item{\code{r_expression()}}{Parse an R expression class and return it's string. }
  \item{\code{factor()}}{Parse a factor class and return it's AST Node.}
  \item{\code{term()}}{Parse a term class and return it's AST Node.}
  \item{\code{expression()}}{Parse an expression class and return it's AST Node.}
  \item{\code{table_formula()}}{Parse a table formula class and return it's AST Node.}
  \item{\code{run(input)}}{Run the parser on the given input, and return an AST}
}
}

\section{References}{

\describe{
     Aho, A. V., Lam, M. S., Sethi, R., and Ullman, J. D. (2006) \emph{Compilers: Principles, Techniques, and Tools}, 2nd edition. Addison Wesley.
}
}

\examples{
Parser$new()$run("col1 + col2 + col3 ~ drug*age+spiders")

}
\keyword{data}
