% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_visnetwork.R
\name{tar_visnetwork}
\alias{tar_visnetwork}
\title{Visualize an abridged fast dependency graph.}
\usage{
tar_visnetwork(
  targets_only = FALSE,
  allow = NULL,
  exclude = NULL,
  outdated = TRUE,
  label = NULL,
  level_separation = NULL,
  reporter = "silent",
  callr_function = callr::r,
  callr_arguments = list(spinner = identical(reporter, "silent"))
)
}
\arguments{
\item{targets_only}{Logical, whether to restrict the output to just targets
(\code{FALSE}) or to also include imported global functions and objects.}

\item{allow}{Optional, define the set of allowable vertices in the graph.
Set to \code{NULL} to allow all vertices in the pipeline and environment
(default). Otherwise, you can supply symbols, a character vector, or
\code{tidyselect} helpers like \code{\link[=starts_with]{starts_with()}}.}

\item{exclude}{Optional, define the set of exclude vertices from the graph.
Set to \code{NULL} to exclude no vertices.
Otherwise, you can supply symbols, a character vector, or \code{tidyselect}
helpers like \code{\link[=starts_with]{starts_with()}}.}

\item{outdated}{Logical, whether to show colors to distinguish outdated
targets from up-to-date targets. (Global functions and objects
still show these colors.) Looking for outdated targets
takes a lot of time for large pipelines with lots of branches,
and setting \code{outdated} to \code{FALSE} is a nice way to speed up the graph
if you only want to see dependency relationships and build progress.}

\item{label}{Character vector of one or more aesthetics to add to the
vertex labels. Can contain \code{"time"} to show total runtime, \code{"size"}
to show total storage size, or \code{"branches"} to show the number of
branches in each pattern. You can choose multiple aesthetics
at once, e.g. \code{label = c("time", "branches")}. All are disabled
by default because they clutter the graph.}

\item{level_separation}{Numeric of length 1,
\code{levelSeparation} argument of \code{visNetwork::visHierarchicalLayout()}.
Controls the distance between hierarchical levels.
Consider changing the value if the aspect ratio of the graph
is far from 1. If \code{level_separation} is \code{NULL},
the \code{levelSeparation} argument of \code{visHierarchicalLayout()}
defaults to \code{150}.}

\item{reporter}{Character of length 1, name of the reporter to user.
Controls how messages are printed as targets are checked. Choices:
\itemize{
\item \code{"silent"}: print nothing.
\item \code{"forecast"}: print running totals of the checked and outdated
targets found so far.
}}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}
}
\value{
A \code{visNetwork} HTML widget object.
}
\description{
Analyze the pipeline defined in \verb{_targets.R}
and visualize the directed acyclic graph of targets
and imported global functions and objects.
}
\examples{
if (identical(Sys.getenv("TARGETS_INTERACTIVE_EXAMPLES"), "true")) {
tar_dir({ # Write all files to a temporary directory.
tar_script({
  tar_option_set()
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
})
tar_visnetwork()
tar_visnetwork(allow = starts_with("y"))
})
}
}
