% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_resources_aws.R
\name{tar_resources_aws}
\alias{tar_resources_aws}
\title{Target resources: Amazon Web Services (AWS) S3 storage}
\usage{
tar_resources_aws(
  bucket,
  prefix = targets::path_objects_dir_cloud(),
  region = NULL,
  part_size = 5 * (2^20),
  endpoint = NULL
)
}
\arguments{
\item{bucket}{Character of length 1, name of an existing
bucket to upload and download the return values
of the affected targets during the pipeline.}

\item{prefix}{Character of length 1, "directory path"
in the bucket where the target return values are stored.}

\item{region}{Character of length 1, AWS region containing the S3 bucket.
Set to \code{NULL} to use the default region.}

\item{part_size}{Positive numeric of length 1, number of bytes
for each part of a multipart upload. (Except the last part,
which is the remainder.) In a multipart upload, each part
must be at least 5 MB.}

\item{endpoint}{Character of length 1, URL endpoint for S3 storage.
Defaults to the Amazon AWS endpoint if \code{NULL}. Example:
To use the S3 protocol with Google Cloud Storage,
set \code{endpoint = "https://storage.googleapis.com"}
and \code{region = "auto"}. Also make sure to create
HMAC access keys in the Google Cloud Storage console
(under Settings => Interoperability) and set the
\code{AWS_ACCESS_KEY_ID} and \code{AWS_SECRET_ACCESS_KEY} environment
variables accordingly. After that, you should be able to use
S3 storage formats with Google Cloud storage buckets.
There is one limitation, however: even if your bucket has
object versioning turned on, \code{targets} may fail to record object
versions. Google Cloud Storage in particular has this
incompatibility.}
}
\value{
Object of class \code{"tar_resources_aws"}, to be supplied
to the \code{aws} argument of \code{tar_resources()}.
}
\description{
Create the \code{aws} argument of \code{tar_resources()}
to specify optional settings to AWS for
\code{tar_target(..., repository = "aws")}.
See the \code{format} argument of \code{\link[=tar_target]{tar_target()}} for details.
}
\details{
See the cloud storage section of
\url{https://books.ropensci.org/targets/data.html}
for details for instructions.
}
\section{Resources}{

Functions \code{\link[=tar_target]{tar_target()}} and \code{\link[=tar_option_set]{tar_option_set()}}
each takes an optional \code{resources} argument to supply
non-default settings of various optional backends for data storage
and high-performance computing. The \code{tar_resources()} function
is a helper to supply those settings in the correct manner.
Resources are all-or-nothing: if you specify any resources
with \code{\link[=tar_target]{tar_target()}}, all the resources from \code{tar_option_get("resources")}
are dropped for that target. In other words, if you write
\code{tar_option_set(resources = resources_1)} and then
\code{tar_target(x, my_command(), resources = resources_2)}, then everything
in \code{resources_1} is discarded for target \code{x}.
}

\examples{
# Somewhere in you target script file (usually _targets.R):
tar_target(
  name,
  command(),
  format = "qs",
  repository = "aws",
  resources = tar_resources(
    aws = tar_resources_aws(bucket = "yourbucketname"),
    qs = tar_resources_qs(preset = "fast")
  )
)
}
\seealso{
Other resources: 
\code{\link{tar_resources_clustermq}()},
\code{\link{tar_resources_feather}()},
\code{\link{tar_resources_fst}()},
\code{\link{tar_resources_future}()},
\code{\link{tar_resources_gcp}()},
\code{\link{tar_resources_parquet}()},
\code{\link{tar_resources_qs}()},
\code{\link{tar_resources_url}()},
\code{\link{tar_resources}()}
}
\concept{resources}
