% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_make.R
\name{tar_make}
\alias{tar_make}
\title{Run a pipeline of targets.}
\usage{
tar_make(
  names = NULL,
  reporter = Sys.getenv("TAR_MAKE_REPORTER", unset = "verbose"),
  callr_function = callr::r,
  callr_arguments = targets::callr_args_default(callr_function, reporter)
)
}
\arguments{
\item{names}{Names of the targets to build or check. Set to \code{NULL} to
check/build all the targets (default). Otherwise, you can supply
symbols, a character vector, or \code{tidyselect} helpers like \code{\link[=starts_with]{starts_with()}}.}

\item{reporter}{Character of length 1, name of the reporter to user.
Controls how messages are printed as targets run in the pipeline.
Defaults to the \code{TAR_MAKE_REPORTER} environment variable if set
and \code{"verbose"} otherwise. Choices:
\itemize{
\item \code{"verbose"}: print one message for each target that runs (default).
\item \code{"silent"}: print nothing.
\item \code{"timestamp"}: print a time-stamped message for each target that runs.
\item \code{"summary"}: print a running total of the number of each targets in
each status category (queued, started, skipped, build, canceled,
or errored). Also show a timestamp (\code{"\%H:\%M \%OS2"} \code{strptime()} format)
of the last time the progress changed and printed to the screen.
}}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}
}
\value{
\code{NULL} except if \code{callr_function = callr::r_bg()}, in which case
a handle to the \code{callr} background process is returned. Either way,
the value is invisibly returned.
}
\description{
Run the pipeline you defined in \verb{_targets.R}. \code{tar_make()}
runs the correct targets in the correct order and stores the return
values in \verb{_targets/objects/}.
}
\examples{
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  tar_option_set()
  list(tar_target(x, 1 + 1))
})
tar_make()
tar_script({
  tar_option_set()
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
}, ask = FALSE)
tar_make(starts_with("y")) # Only builds y1 and y2.
})
}
\seealso{
Other pipeline: 
\code{\link{tar_make_clustermq}()},
\code{\link{tar_make_future}()}
}
\concept{pipeline}
