% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_option_set.R
\name{tar_option_set}
\alias{tar_option_set}
\title{Set target options.}
\usage{
tar_option_set(
  tidy_eval = NULL,
  packages = NULL,
  imports = NULL,
  library = NULL,
  envir = NULL,
  format = NULL,
  iteration = NULL,
  error = NULL,
  memory = NULL,
  garbage_collection = NULL,
  deployment = NULL,
  priority = NULL,
  backoff = NULL,
  resources = NULL,
  storage = NULL,
  retrieval = NULL,
  cue = NULL,
  debug = NULL,
  workspaces = NULL,
  workspace_on_error = NULL
)
}
\arguments{
\item{tidy_eval}{Logical, whether to enable tidy evaluation
when interpreting \code{command} and \code{pattern}. If \code{TRUE}, you can use the
"bang-bang" operator \verb{!!} to programmatically insert
the values of global objects.}

\item{packages}{Character vector of packages to load right before
the target builds. Use \code{tar_option_set()} to set packages
globally for all subsequent targets you define.}

\item{imports}{Character vector of package names to track
global dependencies. For example, if you write
\code{tar_option_set(imports = "yourAnalysisPackage")} early in your
target script file (default: \verb{_targets.R})
then \code{tar_make()} will automatically rerun or skip targets
in response to changes to the R functions and objects defined in
\code{yourAnalysisPackage}. Does not account for low-level compiled code
such as C/C++ or Fortran. If you supply multiple packages,
e.g. \code{tar_option_set(imports = c("p1", "p2"))}, then the objects in
\code{p1} override the objects in \code{p2} if there are name conflicts.
Similarly, objects in \code{tar_option_get("envir")} override
everything in \code{tar_option_get("imports")}.}

\item{library}{Character vector of library paths to try
when loading \code{packages}.}

\item{envir}{Environment containing functions and global objects
common to all targets in the pipeline.
The \code{envir} argument of \code{\link[=tar_make]{tar_make()}} and related functions
always overrides the current value of \code{tar_option_get("envir")}
in the current R session just before running the target script file,
so whenever you need to set an alternative \code{envir}, you should always set
it with \code{tar_option_set()} from within the target script file.
In other words, if you call \code{tar_option_set(envir = envir1)} in an
interactive session and then
\code{tar_make(envir = envir2, callr_function = NULL)},
then \code{envir2} will be used.

If \code{envir} is the global environment, all the promise objects
are diffused before sending the data to parallel workers
in \code{\link[=tar_make_future]{tar_make_future()}} and \code{\link[=tar_make_clustermq]{tar_make_clustermq()}},
but otherwise the environment is unmodified.
This behavior improves performance by decreasing
the size of data sent to workers.

If \code{envir} is not the global environment, then it should at least inherit
from the global environment or base environment
so \code{targets} can access attached packages.
In the case of a non-global \code{envir}, \code{targets} attempts to remove
potentially high memory objects that come directly from \code{targets}.
That includes \code{tar_target()} objects of class \code{"tar_target"},
as well as objects of class \code{"tar_pipeline"} or \code{"tar_algorithm"}.
This behavior improves performance by decreasing
the size of data sent to workers.

Package environments should not be assigned to \code{envir}.
To include package objects as upstream dependencies in the pipeline,
assign the package to the \code{packages} and \code{imports} arguments
of \code{tar_option_set()}.}

\item{format}{Optional storage format for the target's return value.
With the exception of \code{format = "file"}, each target
gets a file in \verb{_targets/objects}, and each format is a different
way to save and load this file. See the "Storage formats" section
for a detailed list of possible data storage formats.}

\item{iteration}{Character of length 1, name of the iteration mode
of the target. Choices:
\itemize{
\item \code{"vector"}: branching happens with \code{vctrs::vec_slice()} and
aggregation happens with \code{vctrs::vec_c()}.
\item \code{"list"}, branching happens with \verb{[[]]} and aggregation happens with
\code{list()}.
\item \code{"group"}: \code{dplyr::group_by()}-like functionality to branch over
subsets of a data frame. The target's return value must be a data
frame with a special \code{tar_group} column of consecutive integers
from 1 through the number of groups. Each integer designates a group,
and a branch is created for each collection of rows in a group.
See the \code{\link[=tar_group]{tar_group()}} function to see how you can
create the special \code{tar_group} column with \code{dplyr::group_by()}.
}}

\item{error}{Character of length 1, what to do if the target
stops and throws an error. Options:
\itemize{
\item \code{"stop"}: the whole pipeline stops and throws an error.
\item \code{"continue"}: the whole pipeline keeps going.
\item \code{"abridge"}: any currently running targets keep running,
but no new targets launch after that.
(Visit \url{https://books.ropensci.org/targets/debugging.html}
to learn how to debug targets using saved workspaces.)
}}

\item{memory}{Character of length 1, memory strategy.
If \code{"persistent"}, the target stays in memory
until the end of the pipeline (unless \code{storage} is \code{"worker"},
in which case \code{targets} unloads the value from memory
right after storing it in order to avoid sending
copious data over a network).
If \code{"transient"}, the target gets unloaded
after every new target completes.
Either way, the target gets automatically loaded into memory
whenever another target needs the value.
For cloud-based dynamic files such as \code{format = "aws_file"},
this memory strategy applies to
temporary local copies of the file in \verb{_targets/scratch/"}:
\code{"persistent"} means they remain until the end of the pipeline,
and \code{"transient"} means they get deleted from the file system
as soon as possible. The former conserves bandwidth,
and the latter conserves local storage.}

\item{garbage_collection}{Logical, whether to run \code{base::gc()}
just before the target runs.}

\item{deployment}{Character of length 1, only relevant to
\code{\link[=tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[=tar_make_future]{tar_make_future()}}. If \code{"worker"},
the target builds on a parallel worker. If \code{"main"},
the target builds on the host machine / process managing the pipeline.}

\item{priority}{Numeric of length 1 between 0 and 1. Controls which
targets get deployed first when multiple competing targets are ready
simultaneously. Targets with priorities closer to 1 get built earlier
(and polled earlier in \code{\link[=tar_make_future]{tar_make_future()}}).}

\item{backoff}{Numeric of length 1, must be greater than or equal to 0.01.
Maximum upper bound of the random polling interval
for the priority queue (seconds).
In high-performance computing (e.g. \code{\link[=tar_make_clustermq]{tar_make_clustermq()}}
and \code{\link[=tar_make_future]{tar_make_future()}}) it can be expensive to repeatedly poll the
priority queue if no targets are ready to process. The number of seconds
between polls is \code{runif(1, 0.001, max(backoff, 0.001 * 1.5 ^ index))},
where \code{index} is the number of consecutive polls so far that found
no targets ready to skip or run.
(If no target is ready, \code{index} goes up by 1. If a target is ready,
\code{index} resets to 0. For more information on exponential,
backoff, visit \url{https://en.wikipedia.org/wiki/Exponential_backoff}).
Raising \code{backoff} is kinder to the CPU etc. but may incur delays
in some instances.}

\item{resources}{Object returned by \code{tar_resources()}
with optional settings for high-performance computing
functionality, alternative data storage formats,
and other optional capabilities of \code{targets}.
See \code{tar_resources()} for details.}

\item{storage}{Character of length 1, only relevant to
\code{\link[=tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[=tar_make_future]{tar_make_future()}}.
Must be one of the following values:
\itemize{
\item \code{"main"}: the target's return value is sent back to the
host machine and saved/uploaded locally.
\item \code{"worker"}: the worker saves/uploads the value.
\item \code{"none"}: almost never recommended. It is only for
niche situations, e.g. the data needs to be loaded
explicitly from another language. If you do use it,
then the return value of the target is totally ignored
when the target ends, but
each downstream target still attempts to load the data file
(except when \code{retrieval = "none"}).

If you select \code{storage = "none"}, then
the return value of the target's command is ignored,
and the data is not saved automatically.
As with dynamic files (\code{format = "file"} or \code{"aws_file"}) it is the
responsibility of the user to write to
\code{\link[=tar_path]{tar_path()}} from inside the target.
An example target
could look something like
tar_target(x,
{saveRDS("value", tar_path(create_dir = TRUE)); "ignored"},
storage = "none")`.

The distinguishing feature of \code{storage = "none"}
(as opposed to \code{format = "file"} or \code{"aws_file"})
is that in the general case,
downstream targets will automatically try to load the data
from the data store as a dependency. As a corollary, \code{storage = "none"}
is completely unnecessary if \code{format} is \code{"file"} or \code{"aws_file"}.
}}

\item{retrieval}{Character of length 1, only relevant to
\code{\link[=tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[=tar_make_future]{tar_make_future()}}.
Must be one of the following values:
\itemize{
\item \code{"main"}: the target's dependencies are loaded on the host machine
and sent to the worker before the target builds.
\item \code{"worker"}: the worker loads the targets dependencies.
\item \code{"none"}: the dependencies are not loaded at all.
This choice is almost never recommended. It is only for
niche situations, e.g. the data needs to be loaded
explicitly from another language.
}}

\item{cue}{An optional object from \code{tar_cue()} to customize the
rules that decide whether the target is up to date.}

\item{debug}{Character vector of names of targets to run in debug mode.
To use effectively, you must set \code{callr_function = NULL} and
restart your R session just before running. You should also
\code{\link[=tar_make]{tar_make()}}, \code{\link[=tar_make_clustermq]{tar_make_clustermq()}}, or \code{\link[=tar_make_future]{tar_make_future()}}.
For any target mentioned in \code{debug}, \code{targets} will force the target to
build locally (with \code{tar_cue(mode = "always")} and \code{deployment = "main"}
in the settings) and pause in an interactive debugger to help you diagnose
problems. This is like inserting a \code{browser()} statement at the
beginning of the target's expression, but without invalidating any
targets.}

\item{workspaces}{Character vector of target names.
Could be non-branching targets, whole dynamic branching targets,
or individual branch names. \code{\link[=tar_make]{tar_make()}} and friends
will save workspace files for these targets even if
the targets are skipped. Workspace files help with debugging.
See \code{\link[=tar_workspace]{tar_workspace()}} for details about workspaces.}

\item{workspace_on_error}{Logical of length 1, whether to save
a workspace file for each target that throws an error.
Workspace files help with debugging.
See \code{\link[=tar_workspace]{tar_workspace()}} for details about workspaces.}
}
\value{
\code{NULL} (invisibly).
}
\description{
Set target options, including default arguments to
\code{\link[=tar_target]{tar_target()}} such as packages, storage format,
iteration type, and cue. Only the non-null arguments are actually
set as options. See currently set options with \code{\link[=tar_option_get]{tar_option_get()}}.
To use \code{tar_option_set()} effectively, put it in your workflow's
target script file (default: \verb{_targets.R})
before calls to \code{\link[=tar_target]{tar_target()}} or \code{\link[=tar_target_raw]{tar_target_raw()}}.
}
\examples{
tar_option_get("format") # default format before we set anything
tar_target(x, 1)$settings$format
tar_option_set(format = "fst_tbl") # new default format
tar_option_get("format")
tar_target(x, 1)$settings$format
tar_option_reset() # reset the format
tar_target(x, 1)$settings$format
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  tar_option_set(cue = tar_cue(mode = "always")) # All targets always run.
  list(tar_target(x, 1), tar_target(y, 2))
})
tar_make()
tar_make()
})
}
}
\seealso{
Other configuration: 
\code{\link{tar_config_get}()},
\code{\link{tar_config_set}()},
\code{\link{tar_config_unset}()},
\code{\link{tar_envvars}()},
\code{\link{tar_option_get}()},
\code{\link{tar_option_reset}()}
}
\concept{configuration}
