% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_resources_feather.R
\name{tar_resources_feather}
\alias{tar_resources_feather}
\title{Target resources: feather storage formats}
\usage{
tar_resources_feather(compression = "default", compression_level = NULL)
}
\arguments{
\item{compression}{Character of length 1, \code{compression}
argument of \code{arrow::write_feather()}.}

\item{compression_level}{Numeric of length 1, \code{compression_level}
argument of \code{arrow::write_feather()}.}
}
\value{
Object of class \code{"tar_resources_feather"}, to be supplied
to the feather argument of \code{tar_resources()}.
}
\description{
Create the feather argument of \code{tar_resources()}
to specify optional settings for feather data frame storage formats
powered by the \code{arrow} R package.
See the \code{format} argument of \code{\link[=tar_target]{tar_target()}} for details.
}
\section{Resources}{

Functions \code{\link[=tar_target]{tar_target()}} and \code{\link[=tar_option_set]{tar_option_set()}}
each takes an optional \code{resources} argument to supply
non-default settings of various optional backends for data storage
and high-performance computing. The \code{tar_resources()} function
is a helper to supply those settings in the correct manner.
Resources are all-or-nothing: if you specify any resources
with \code{\link[=tar_target]{tar_target()}}, all the resources from \code{tar_option_get("resources")}
are dropped for that target. In other words, if you write
\code{tar_option_set(resources = resources_1)} and then
\code{tar_target(x, my_command(), resources = resources_2)}, then everything
in \code{resources_1} is discarded for target \code{x}.
}

\examples{
# Somewhere in you target script file (usually _targets.R):
tar_target(
  name,
  command(),
  format = "feather",
  resources = tar_resources(
    feather = tar_resources_feather(compression = "lz4")
  )
)
}
\seealso{
Other resources: 
\code{\link{tar_resources_aws}()},
\code{\link{tar_resources_clustermq}()},
\code{\link{tar_resources_fst}()},
\code{\link{tar_resources_future}()},
\code{\link{tar_resources_parquet}()},
\code{\link{tar_resources_qs}()},
\code{\link{tar_resources_url}()},
\code{\link{tar_resources}()}
}
\concept{resources}
