% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_option_get.R
\name{tar_option_get}
\alias{tar_option_get}
\title{Get a target option.}
\usage{
tar_option_get(name = NULL, option = NULL)
}
\arguments{
\item{name}{Character of length 1, name of an option to get.
Must be one of the argument names of \code{\link[=tar_option_set]{tar_option_set()}}.}

\item{option}{Deprecated, use the \code{name} argument instead.}
}
\value{
Value of a target option.
}
\description{
Get a target option. These options include default arguments to
\code{\link[=tar_target]{tar_target()}} such as packages, storage format,
iteration type, and cue.
Needs to be called before any calls to \code{\link[=tar_target]{tar_target()}}
in order to take effect.
}
\details{
This function goes well with \code{\link[=tar_target_raw]{tar_target_raw()}} when it comes
to defining external interfaces on top of the \code{targets} package to create
pipelines.
}
\examples{
tar_option_get("format") # default format before we set anything
tar_target(x, 1)$settings$format
tar_option_set(format = "fst_tbl") # new default format
tar_option_get("format")
tar_target(x, 1)$settings$format
tar_option_reset() # reset the format
tar_target(x, 1)$settings$format
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  library(targets)
  library(tarchetypes)
  tar_option_set(cue = tar_cue(mode = "always")) # All targets always run.
  list(tar_target(x, 1), tar_target(y, 2))
})
tar_make()
tar_make()
})
}
}
\seealso{
Other configuration: 
\code{\link{tar_config_get}()},
\code{\link{tar_config_projects}()},
\code{\link{tar_config_set}()},
\code{\link{tar_config_unset}()},
\code{\link{tar_config_yaml}()},
\code{\link{tar_envvars}()},
\code{\link{tar_option_reset}()},
\code{\link{tar_option_set}()},
\code{\link{tar_option_with}()}
}
\concept{configuration}
