% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nl_med_prices.R
\name{nl_med_prices}
\alias{nl_med_prices}
\title{A function to download the Medical Reference prices of the Dutch Costing Manual for one or multiple years}
\usage{
nl_med_prices(
  year = "all",
  category = "all",
  unit = "all",
  currency = c("EUR", "INT$")
)
}
\arguments{
\item{year}{The year of which the reference price should be downloaded, multiple years are possible, default is the whole dataset}

\item{category}{The category of prices that should be included (one or more categories), default is including all categories}

\item{unit}{The reference price that should be included (one or multiple reference prices),  default is including the whole dataframe}

\item{currency}{The currency of the output of the prices. A decision can be made between EUR and INT$, the default is EUR.}
}
\value{
A dataframe or value with the Medical Reference price(s) of the Dutch Costing Manual for the specified years
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A function downloads the Medical Reference prices of the Dutch Costing Manual for one or multiple years. The prices are available in Euro (EUR) or International Dollar (INT$).
}
\examples{
# Example usage of the nl_med_prices function
# Calculate for year 2023 with the category Nursing
nl_med_prices(year = "2023", category = "Nursing")

# Calculate for year 2022 and 2023 the category Nursing
nl_med_prices(year = "all", category = "Nursing")

# Calculate for year 2022 with the category Nursing in INT$
nl_med_prices(year = "2022", category = "Nursing" , currency = "INT$")

}
\keyword{Costing}
\keyword{Dutch}
\keyword{Generic}
\keyword{Manual}
\keyword{Medical}
\keyword{Prices}
