% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R,
%   R/getter_setter_s3_generics.R, R/taxon.R, R/taxonomy.R
\name{tax_auth.taxa_classification}
\alias{tax_auth.taxa_classification}
\alias{tax_auth<-.taxa_classification}
\alias{tax_auth}
\alias{tax_auth<-}
\alias{tax_auth.taxa_taxon}
\alias{tax_auth<-.taxa_taxon}
\alias{tax_auth.taxa_taxonomy}
\alias{tax_auth<-.taxa_taxonomy}
\title{Set and get taxon authorities}
\usage{
\method{tax_auth}{taxa_classification}(x)

\method{tax_auth}{taxa_classification}(x) <- value

tax_auth(x)

tax_auth(x) <- value

\method{tax_auth}{taxa_taxon}(x)

\method{tax_auth}{taxa_taxon}(x) <- value

\method{tax_auth}{taxa_taxonomy}(x)

\method{tax_auth}{taxa_taxonomy}(x) <- value
}
\arguments{
\item{x}{An object with taxon authorities.}

\item{value}{The taxon IDs to set. Inputs will be coerced into a \link{taxon_id} vector.}
}
\description{
Set and get the taxon authorities in objects that have them, such as \link{taxon} objects.
Note that this sets all the authority information, such as author name, date, and citations.
To set or get just one of part of the authorities, use \link{tax_author}, \link{tax_date}, or \link{tax_cite} instead.
}
\examples{
x <- taxon(name = c('Homo sapiens', 'Bacillus', 'Ascomycota', 'Ericaceae'),
           rank = c('species', 'genus', 'phylum', 'family'),
           id = taxon_id(c('9606', '1386', '4890', '4345'), db = 'ncbi'),
           auth = c('Linnaeus, 1758', 'Cohn 1872', NA, 'Juss., 1789'))

tax_auth(x)
tax_auth(x) <- tolower(tax_auth(x))
tax_auth(x)[1] <- 'Billy'

}
