% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R,
%   R/getter_setter_s3_generics.R, R/taxon.R, R/taxonomy.R
\name{tax_id.taxa_classification}
\alias{tax_id.taxa_classification}
\alias{tax_id<-.taxa_classification}
\alias{tax_id}
\alias{tax_id<-}
\alias{tax_id.taxa_taxon}
\alias{tax_id<-.taxa_taxon}
\alias{tax_id.taxa_taxonomy}
\alias{tax_id<-.taxa_taxonomy}
\title{Set and get taxon IDs}
\usage{
\method{tax_id}{taxa_classification}(x)

\method{tax_id}{taxa_classification}(x) <- value

tax_id(x)

tax_id(x) <- value

\method{tax_id}{taxa_taxon}(x)

\method{tax_id}{taxa_taxon}(x) <- value

\method{tax_id}{taxa_taxonomy}(x)

\method{tax_id}{taxa_taxonomy}(x) <- value
}
\arguments{
\item{x}{An object with taxon IDs.}

\item{value}{The taxon IDs to set. Inputs will be coerced into a \link{taxon_id} vector.}
}
\description{
Set and get the taxon IDs in objects that have them, such as \link{taxon} objects.
}
\examples{
x <- taxon(name = c('Homo sapiens', 'Bacillus', 'Ascomycota', 'Ericaceae'),
           rank = c('species', 'genus', 'phylum', 'family'),
           id = taxon_id(c('9606', '1386', '4890', '4345'), db = 'ncbi'),
           auth = c('Linnaeus, 1758', 'Cohn 1872', NA, 'Juss., 1789'))

tax_id(x)
tax_id(x) <- paste0('00', tax_id(x))
tax_id(x)[1] <- '00000'

}
