% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tl_import.R
\name{tl_import}
\alias{tl_import}
\title{Import taxonomic database tables}
\usage{
tl_import(
  provider = getOption("tl_default_provider", "itis"),
  schema = c("dwc", "common"),
  version = latest_version(),
  prov = prov_cache()
)
}
\arguments{
\item{provider}{from which provider should the hierarchy be returned?
Default is 'itis', which can also be configured using \verb{options(default_taxadb_provider=...")}.
See \verb{[td_create]} for a list of recognized providers.}

\item{schema}{One of "dwc" (for Darwin Core data) or "common"
(for the Common names table.)}

\item{version}{Which version of the taxadb provider database should we use?
defaults to latest.  See \link{tl_import} for details.}

\item{prov}{Address (URL) to provenance record}
}
\value{
path(s) to the downloaded files in the cache
}
\description{
Downloads the requested taxonomic data tables and return a local path
to the data in \code{tsv.gz} format.  Downloads are cached and identified by
content hash so that \code{tl_import} will not attempt to download the
same file multiple times.
}
\details{
\code{tl_import} parses a schema.org record to determine the correct version
to download. If offline, \code{tl_import} will attempt to resolve against
it's own provenance cache. Users can also examine / parse the prov
JSON-LD file directly to determine the provenance of the data products
used.
}
