% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tl.R
\name{get_names}
\alias{get_names}
\title{Return \code{scientificName} names given taxonomic identifiers}
\usage{
get_names(
  id,
  provider = getOption("tl_default_provider", "itis"),
  version = tl_latest_version(),
  dir = tl_dir()
)
}
\arguments{
\item{id}{a character vector of taxonomic identifiers, including provider prefix}

\item{provider}{Abbreviation for a known naming provider.
Provider data should first be imported with \verb{[tl_create]}.
Note: setting provider to \code{"itis_test"} is for testing purposes only,
use \code{"itis"} for the full ITIS data.  See details}

\item{version}{version of the authority to use (e.g. four-digit year)}

\item{dir}{storage location for the LMDB databases}
}
\value{
a vector of matching scientific names
}
\description{
Return \code{scientificName} names given taxonomic identifiers
}
\examples{
\dontshow{Sys.setenv(TAXALIGHT_HOME=tempfile())}
\donttest{ # slow initial import
get_names(c("ITIS:180092", "ITIS:179913"))
}
\dontshow{Sys.unsetenv("TAXALIGHT_HOME")}

}
