% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncbi_get_taxon_summary.R
\name{ncbi_get_taxon_summary}
\alias{ncbi_get_taxon_summary}
\title{NCBI taxon information from uids}
\usage{
ncbi_get_taxon_summary(id, ...)
}
\arguments{
\item{id}{(character) NCBI taxonomy uids to retrieve information for.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A \code{data.frame} with the following rows:
  \describe{
    \item{uid}{The uid queried for}
    \item{name}{The name of the taxon; a binomial name if the taxon is of rank species}
    \item{rank}{The taxonomic rank (e.g. 'Genus')}
  }
}
\description{
Downloads summary taxon information from the NCBI taxonomy databases
for a set of taxonomy UIDs using eutils esummary.
}
\examples{
\dontrun{
ncbi_get_taxon_summary(c(1430660, 4751))

# use curl options
library("httr")
ncbi_get_taxon_summary(c(1430660, 4751), config = verbose())
}
}
\author{
Zachary Foster \email{zacharyfoster1989@Sgmail.com}
}

