% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_colid.R
\name{get_colid}
\alias{get_colid}
\alias{as.colid}
\alias{as.colid.colid}
\alias{as.colid.character}
\alias{as.colid.list}
\alias{as.colid.data.frame}
\alias{as.data.frame.colid}
\alias{get_colid_}
\title{Get the Catalogue of Life ID from taxonomic names.}
\usage{
get_colid(sciname, ask = TRUE, messages = TRUE, rows = NA,
  kingdom = NULL, phylum = NULL, class = NULL, order = NULL,
  family = NULL, rank = NULL, ...)

as.colid(x, check = TRUE)

\method{as.colid}{colid}(x, check = TRUE)

\method{as.colid}{character}(x, check = TRUE)

\method{as.colid}{list}(x, check = TRUE)

\method{as.colid}{data.frame}(x, check = TRUE)

\method{as.data.frame}{colid}(x, ...)

get_colid_(sciname, messages = TRUE, rows = NA)
}
\arguments{
\item{sciname}{character; scientific name.}

\item{ask}{logical; should get_colid be run in interactive mode?
If TRUE and more than one ID is found for the species, the user is asked for
input. If FALSE NA is returned for multiple matches.}

\item{messages}{logical; If TRUE the actual taxon queried is printed on the
console.}

\item{rows}{numeric; Any number from 1 to infinity. If the default NA, all rows are considered.
Note that this function still only gives back a colid class object with one to many identifiers.
See \code{\link[taxize]{get_colid_}} to get back all, or a subset, of the raw data that you are
presented during the ask process.}

\item{kingdom}{(character) A kingdom name. Optional. See \code{Filtering}
below.}

\item{phylum}{(character) A phylum (aka division) name. Optional. See \code{Filtering}
below.}

\item{class}{(character) A class name. Optional. See \code{Filtering} below.}

\item{order}{(character) An order name. Optional. See \code{Filtering} below.}

\item{family}{(character) A family name. Optional. See \code{Filtering} below.}

\item{rank}{(character) A taxonomic rank name. See \code{\link{rank_ref}} for possible
options. Though note that some data sources use atypical ranks, so inspect the
data itself for options. Optional. See \code{Filtering} below.}

\item{...}{Ignored}

\item{x}{Input to as.colid}

\item{check}{logical; Check if ID matches any existing on the DB, only used in
\code{\link{as.colid}}}
}
\value{
A vector of taxonomic identifiers as an S3 class.
If a taxon is not found an \code{NA} is given. If more than one identifier
is found the function asks for user input if \code{ask = TRUE}, otherwise
returns \code{NA}. If \code{ask=FALSE} and \code{rows} does not equal
\code{NA}, then a data.frame is given back, but not of the uid class, which
you can't pass on to other functions as you normally can.

See \code{\link{get_id_details}} for further details including
attributes and exceptions
}
\description{
Get the Catalogue of Life ID from taxonomic names.
}
\section{Filtering}{

The parameters \code{kingdom}, \code{phylum}, \code{class}, \code{order}, \code{family},
and \code{rank} are not used in the search to the data provider, but are used in filtering
the data down to a subset that is closer to the target you want. For all these parameters,
you can use regex strings since we use \code{\link{grep}} internally to match.
Filtering narrows down to the set that matches your query, and removes the rest.
}

\examples{
\dontrun{
get_colid(sciname='Poa annua')
get_colid(sciname='Pinus contorta')
get_colid(sciname='Puma concolor')
# get_colid(sciname="Abudefduf saxatilis")

get_colid(c("Poa annua", "Pinus contorta"))

# specify rows to limit choices available
get_colid(sciname='Poa annua')
get_colid(sciname='Poa annua', rows=1)
get_colid(sciname='Poa annua', rows=2)
get_colid(sciname='Poa annua', rows=1:2)

# When not found
get_colid(sciname="uaudnadndj")
get_colid(c("Chironomus riparius", "uaudnadndj"))

# Narrow down results to a division or rank, or both
## Satyrium example
### Results w/o narrowing
get_colid("Satyrium")
### w/ division
get_colid("Satyrium", kingdom = "Plantae")
get_colid("Satyrium", kingdom = "Animalia")

## Rank example
get_colid("Poa")
get_colid("Poa", kingdom = "Plantae")
get_colid("Poa", kingdom = "Animalia")

# Fuzzy filter on any filtering fields
## uses grep on the inside
get_colid("Satyrium", kingdom = "p")

# Convert a uid without class information to a uid class
as.colid(get_colid("Chironomus riparius")) # already a uid, returns the same
as.colid(get_colid(c("Chironomus riparius","Pinus contorta"))) # same
as.colid("714831352ad94741e4321eccdeb29f58") # character
# character vector, length > 1
as.colid(c("714831352ad94741e4321eccdeb29f58", "3b35900f74ff6e4b073ddb95c32b1f8d"))
# list, either numeric or character
as.colid(list("714831352ad94741e4321eccdeb29f58", "3b35900f74ff6e4b073ddb95c32b1f8d"))
## dont check, much faster
as.colid("714831352ad94741e4321eccdeb29f58", check=FALSE)
as.colid(c("714831352ad94741e4321eccdeb29f58", "3b35900f74ff6e4b073ddb95c32b1f8d"),
 check=FALSE)
as.colid(list("714831352ad94741e4321eccdeb29f58", "3b35900f74ff6e4b073ddb95c32b1f8d"),
 check=FALSE)

(out <- as.colid(c("714831352ad94741e4321eccdeb29f58", "3b35900f74ff6e4b073ddb95c32b1f8d")))
data.frame(out)
as.colid( data.frame(out) )

# Get all data back
get_colid_("Poa annua")
get_colid_("Poa annua", rows=2)
get_colid_("Poa annua", rows=1:2)
get_colid_(c("asdfadfasd","Pinus contorta"))

get_colid(sciname="Andropadus nigriceps fusciceps", rows=1)

# use curl options
get_colid("Quercus douglasii", verbose = TRUE)
}
}
\seealso{
\code{\link[taxize]{classification}}

Other taxonomic-ids: \code{\link{get_boldid}},
  \code{\link{get_eolid}}, \code{\link{get_gbifid}},
  \code{\link{get_ids}}, \code{\link{get_iucn}},
  \code{\link{get_natservid}}, \code{\link{get_nbnid}},
  \code{\link{get_tolid}}, \code{\link{get_tpsid}},
  \code{\link{get_tsn}}, \code{\link{get_uid}},
  \code{\link{get_wiki}}, \code{\link{get_wormsid}}
}
\author{
Scott Chamberlain, \email{myrmecocystus@gmail.com}
}
\concept{taxonomic-ids}
