% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{resumableDownload}
\alias{resumableDownload}
\title{Download file using curl allowing resumption of interrupted files}
\usage{
resumableDownload(
  url,
  outFile = basename(url),
  tmpFile = sprintf("\%s.__TMP__", outFile),
  quiet = FALSE,
  resume = TRUE,
  ...
)
}
\arguments{
\item{url}{The address to download from}

\item{outFile}{The file location to store final download at}

\item{tmpFile}{The file location to store the intermediate download at}

\item{quiet}{If TRUE show the progress reported by \code{multi_download}}

\item{resume}{If TRUE try to resume interrupted downloads using intermediate file \code{tmpFile}. Otherwise delete \code{tempFile} on error}

\item{...}{Additional arguments to \code{multi_download}}
}
\value{
invisibly return the output frmo multi_download
}
\description{
A helper function that uses the \code{curl} package's \code{multi_download} to download a file using a temporary file to store progress and resume downloading on interruption.
}
\examples{
\dontrun{
  url<-'https://ftp.ncbi.nih.gov/pub/taxonomy/accession2taxid/prot.accession2taxid.FULL.1.gz'
  resumableDownload(url,'downloadedFile.gz')
}
}
\seealso{
\code{\link[curl]{multi_download}}
}
