% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{prepareDatabase}
\alias{prepareDatabase}
\title{Download data from NCBI and set up SQLite database}
\usage{
prepareDatabase(sqlFile = "nameNode.sqlite", tmpDir = ".", vocal = TRUE, ...)
}
\arguments{
\item{sqlFile}{character string giving the file location to store the SQLite database}

\item{tmpDir}{location for storing the downloaded files from NCBI. (Note that it may be useful to store these somewhere convenient to avoid redownloading)}

\item{vocal}{if TRUE output messages describing progress}

\item{...}{additional arguments to getNamesAndNodes, getAccession2taxid or read.accession2taxid}
}
\value{
a vector of character string giving the path to the SQLite file
}
\description{
Convenience function to do all necessary preparations downloading names, nodes and accession2taxid data from NCBI and preprocessing into a SQLite database for downstream use.
}
\examples{
\dontrun{
  if(readline(
    "This will download a lot data and take a while to process.
     Make sure you have space and bandwidth. Type y to continue: "
  )!='y')
    stop('This is a stop to make sure no one downloads a bunch of data unintentionally')

  prepareDatabase()
}
}
\seealso{
\code{\link{getNamesAndNodes}}, \code{\link{getAccession2taxid}}, \code{\link{read.accession2taxid}}, \code{\link{read.nodes.sql}}, \code{\link{read.names.sql}}
}
