% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_lists.R
\name{match_lists}
\alias{match_lists}
\title{match two taxonomic lists}
\usage{
match_lists(master, checklist, masterfld, checklistfld)
}
\arguments{
\item{master}{master taxonomic list}

\item{checklist}{match  taxonomic list}

\item{masterfld}{field name for canonical name in master list}

\item{checklistfld}{field name for canonical name in match list}
}
\value{
a list with data frames containing matched records,
records only in master and checklist and statistics about the
records including Jaccard index
}
\description{
match two taxonomic lists using canonical names
}
\examples{
\donttest{
master <- data.frame("canonical" = c("Abrothrix longipilis",
                                    "Acodon hirtus",
                                    "Akodon longipilis apta",
                                    "Akodon longipilis castaneus",
                                    "Chroeomys jelskii",
                                    "Acodon jelskii pyrrhotis"),
                    stringsAsFactors = FALSE)
checklist <- data.frame("canonical" = c("Abrothrix longipilis",
                                    "Akodon longipilis apta",
                                    "Akodon longipilis castaneus",
                                    "Abrothrix jelskii",
                                    "Acodon jelskii pyrrhotis"),
                    stringsAsFactors = FALSE)
match_lists(master,checklist,"canonical","canonical")
}
}
\seealso{
Other List functions: 
\code{\link{DwC2taxo}()},
\code{\link{cast_cs_field}()},
\code{\link{compact_ids}()},
\code{\link{get_synonyms}()},
\code{\link{melt_cs_field}()},
\code{\link{merge_lists}()},
\code{\link{syn2taxo}()},
\code{\link{synonymize_subspecies}()},
\code{\link{taxo2DwC}()},
\code{\link{taxo2doc}()},
\code{\link{taxo2syn}()},
\code{\link{wiki2taxo}()}
}
\concept{List functions}
