% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast_canonical.R
\name{cast_canonical}
\alias{cast_canonical}
\title{Construct canonical names}
\usage{
cast_canonical(dat, genus = "", species = "", subspecies = "")
}
\arguments{
\item{dat}{data frame containing taxonomic list}

\item{genus}{field name for Genus field}

\item{species}{field name for Species field}

\item{subspecies}{field name for Subspecies field}
}
\value{
a data frame containing Canonical names field added or repopulated using
    filed names for Genus, Species and Subspecies specified in parameters
}
\description{
Construct canonical names using Genus, Species and Subspecies fields. At times
due to spaces or NAs in the data fields, it makes it tricky to generate
canonical names.
}
\examples{
\dontrun{
cast_canonical(mylist,"genus","species","subspecies")
}
}
\seealso{
Other Name functions: \code{\link{check_scientific}},
  \code{\link{expand_name}},
  \code{\link{guess_taxo_level}},
  \code{\link{list_higher_taxo}},
  \code{\link{melt_canonical}}
}
\concept{Name functions}
