% Generated by roxygen2 (4.0.2): do not edit by hand
\name{codon.variants}
\alias{codon.variants}
\alias{reverse.translation}
\alias{translated.nucl.sequences}
\title{Functions for working with aminoacid sequences.}
\usage{
codon.variants(.aaseq, .nucseq = sapply(1:length(.aaseq),
               function (i) paste0(rep('XXX', times = nchar(.aaseq[i])),
               collapse = '')))

translated.nucl.sequences(.aaseq, .nucseq = sapply(1:length(.aaseq),
                          function (i) paste0(rep('XXX', times = nchar(.aaseq[i])),
                          collapse = '')))

reverse.translation(.aaseq, .nucseq = paste0(rep('XXX', times = nchar(.aaseq)),
                   collapse = ''))
}
\arguments{
\item{.aaseq}{Amino acid sequence.}

\item{.nucseq}{Nucleotide sequence with 'X' letter at non-fixed positions. Other positions will be fixed.}
}
\value{
List with all possible variants for every aminoacid in .aaseq, number of sequences or
character vector of candidate sequences.
}
\description{
\code{codon.variants} - get all codon variants for the given nucleotide sequence with known corresponding aminoacid sequence.

\code{translated.nucl.variants} - get number of nucleotide sequences which can be translated to the given aminoacid sequence.

\code{reverse.translation} - get all nucleotide sequences, which can be traslated to the given aminoacid sequence.
}
\examples{
codon.variants('ACT')
translated.nucl.sequences(c('ACT', 'CASSLQ'))
reverse.translation('T')  # -> "ACA" "ACC" "ACG" "ACT"
reverse.translation('T', 'XXT')  # -> "ACT"
translated.nucl.sequences('ACT', 'XXXXXXXC')
codon.variants('ACT', 'XXXXXXXC')
reverse.translation('ACT', 'XXXXXXXC')
}

