% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{vis.radarlike}
\alias{vis.radarlike}
\title{Radar-like / spider-like plots.}
\usage{
vis.radarlike(.data, .ncol = 3, .which = NA, .expand = c(0.25, 0))
}
\arguments{
\item{.data}{Square data frame or matrix with row names and col names stands for objects and values for distances.}

\item{.ncol}{Number of columns in the grid.}

\item{.which}{Character vector, which datasets to show.}

\item{.expand}{Integer vector of length 2, for \code{scale_y_continous(expand = .expand)} function.}
}
\description{
Plot a grid of radar(-like) plots for visualising a distance among objects.
}
\examples{
\dontrun{
load('immdata.rda')
# Compute Jensen-Shannon divergence among V-usage of repertoires.
imm.js <- js.div.seg(immdata, .verbose = F)
# Plot it.
vis.radarlike(imm.js)
}
}
\seealso{
\link{repOverlap}, \link{js.div}
}
