% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_pvalue.R
\name{calculate_pvalue}
\alias{calculate_pvalue}
\title{Corrected Wilcoxon tests}
\usage{
calculate_pvalue(
  x,
  method_test = "wilcox_test",
  method_adjust = "BH",
  p_threshold = 0.05
)
}
\arguments{
\item{x}{object from \code{\link[=convert2biodata]{convert2biodata()}} for a dataframe containing
columns named high (logical), cell_type (factor) and value (float).}

\item{method_test}{character for the choice of the statistical test among
't_test' or 'wilcox_test'.}

\item{method_adjust}{character for the choice of the multiple correction test
among 'BH', 'bonferroni', 'BY', 'fdr', 'hochberg', 'holm', 'hommel', 'none'}

\item{p_threshold}{float for the significativity threshold of the P-value.}
}
\value{
rstatix_test object for a table with cell types in the row and
P-values, corrections and other statistics in the column.
}
\description{
Displays stars for each cell type corresponding to the significance level
of two mean comparison tests between expression levels (high or low) with
multiple correction.
}
\examples{
data(tcga)
(df <- convert2biodata(
    algorithm = "Cibersort_ABS",
    disease = "breast invasive carcinoma",
    tissue = "Primary Tumor",
    gene_x = "ICOS"
))
\donttest{
calculate_pvalue(df)
}
calculate_pvalue(
    df,
    method_test = "t_test",
    method_adjust = "bonferroni",
    p_threshold = 0.01
)
}
