% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{gen_data}
\alias{gen_data}
\title{Function to simulate data from a specified PK or PK-PD model with a specified infusion schedule.}
\usage{
gen_data(
  inf,
  pkmod,
  pars_pk0,
  sigma_add = 0,
  sigma_mult = 0,
  log_err = FALSE,
  init = NULL,
  tms = NULL,
  pdmod = NULL,
  pars_pd0 = NULL,
  ecmpt = NULL,
  delay = 0,
  max_pdval = 100,
  min_pdval = 0
)
}
\arguments{
\item{inf}{An infusion rate object outputted from either the 'create_intvl' function or the 'iterate_tci_grid' function}

\item{pkmod}{PK model}

\item{pars_pk0}{"True" parameter estimates used to simulate data observations.}

\item{sigma_add}{Additive residual error standard deviation.}

\item{sigma_mult}{Multiplicative residual error standard deviation.}

\item{log_err}{Logical. Should the error be log-normally distributed?}

\item{init}{Initial concentrations.}

\item{tms}{Observation times. Defaults to beginning of each infusion if unspecified.}

\item{pdmod}{PD model if applicable.}

\item{pars_pd0}{PD model parameters if applicable.}

\item{ecmpt}{Effect-site compartment number. Defaults to last compartment.}

\item{delay}{Delay between generation and observation of measurements.}

\item{max_pdval}{Maximum PD value.}

\item{min_pdval}{Minimum PD value}
}
\value{
Returns a list of simulated responses with class 'datasim' corresponding to the infusion schedule provided.
A "plot.datasim" method exists for visualizing results.
}
\description{
Function to simulate data from a specified PK or PK-PD model with a specified infusion schedule.
}
