% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplLoadChem.R
\name{tcplLoadChem}
\alias{tcplLoadChem}
\title{Load sample/chemical information}
\usage{
tcplLoadChem(field = NULL, val = NULL, exact = TRUE,
  include.spid = TRUE)
}
\arguments{
\item{field}{Character of length 1, the field to query on}

\item{val}{Vector of values to subset on}

\item{exact}{Logical, should chemical names be considered exact?}

\item{include.spid}{Logical, should spid be included?}
}
\value{
A data.table with the chemical information for the given parameters
}
\description{
\code{tcplLoadChem} queries the tcpl database and returns the chemcial 
information for the given field and values.
}
\details{
The 'field' parameter is named differently from the 'fld' parameter seen
in other functions because it only takes one input.

The functionality of the 'exact' parameter cannot be demonstrated within
the SQLite environment. However, in the MySQL environment the user should
be able to give parital chemcial name strings, to find chemicals with 
similar names. For example, setting 'val' to "phenol" when 'field' is "chnm"
and 'exact' is \code{FALSE} might pull up the chemicals "Bisphenol A" and
"4-Butylphenol". More technically, setting 'exact' to \code{FALSE} passes
the string in 'val' to an RLIKE statement within the MySQL query.
}
\examples{
## Store the current config settings, so they can be reloaded at the end 
## of the examples
conf_store <- tcplConfList()
tcplConfDefault()

## Passing no parameters gives all of the registered chemicals with their
## sample IDs
tcplLoadChem()

## Or the user can exclude spid and get a unique list of chemicals
tcplLoadChem(include.spid = FALSE)

## Other examples:
tcplLoadChem(field = "chnm", val = "Bisphenol A")
tcplLoadChem(field = "chid", val = 1:5)

## Reset configuration
options(conf_store)

}

