% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config_funcs.R, R/tcplConf.R,
%   R/tcplConfDefault.R, R/tcplConfList.R, R/tcplConfLoad.R, R/tcplConfReset.R,
%   R/tcplConfSave.R
\name{Configure functions}
\alias{Configure functions}
\alias{tcplConf}
\alias{tcplConfDefault}
\alias{tcplConfList}
\alias{tcplConfLoad}
\alias{tcplConfReset}
\alias{tcplConfSave}
\title{Functions for configuring the tcpl package}
\usage{
tcplConf(drvr = NULL, user = NULL, pass = NULL, host = NULL, db = NULL, ...)

tcplConfDefault()

tcplConfList(show.pass = FALSE)

tcplConfLoad(list.new = TRUE)

tcplConfReset()

tcplConfSave()
}
\arguments{
\item{drvr}{Character of length 1, which database driver to use}

\item{user}{Character of length 1, the database server username}

\item{pass}{Character of length 1, the database server password}

\item{host}{Character of length 1, the database server}

\item{db}{Character of length 1, the name of the tcpl database}

\item{...}{Additional arguments that should be passed to dbConnect function}

\item{show.pass}{Logical, should the password be returned}

\item{list.new}{Logical of length 1, should the new settings be printed?}
}
\description{
These functions are used to configure the tcpl settings.
}
\details{
Currently, the tcpl package supports the "MySQL", "example", and "API" 
database drivers.

The settings can be stored in a configuration file to make the using the 
package more user-friendly. To create the configuration file, the user must
first create a system environment variable ('TCPL_CONF') that points to to 
the file. There is more information about system environment variables in
\code{\link{Startup}} and \code{\link{Sys.getenv}}. Briefly, the user 
needs to modify the '.Renviron' file in their home directory. If the file
does not exist, create it, and add the following line:

TCPL_CONF=path/to/confFile.conf

Here 'path/to/confFile.conf' can be any path to a file. One suggestion would
be to include .tcplConf in the home directory, e.g. TCPL_CONF=~/.tcplConf. 
Note, '~' may not indicate the home directory on every operating system.
Once the environment variable is added, the user can change the settings
using \code{tcplConf}, then save the settings to the file given by the
TCPL_CONF environment variable running \code{tcplConfSave()}. 

\code{tcplConf} changes \code{options} to set the tcpl-specific options, 
most importantly to configure the connection to the tcpl databases. 
\code{tcplConf} will only change non-null values, and can be used to 
change a single value if needed. 

\code{tcplConfSave} modifies the configuration file to reflect the current
tcpl settings.

\code{tcplConfList} lists the values assigned to the tcpl global options.

\code{tcplConfLoad} updates the tcpl settings to reflect the current 
configuration file.

\code{tcplConfDefault} changes the \code{options} to reflect the default
settings for the API connection, but does not alter the configuration file.

\code{tcplConfReset} is used to generate the initial configuration script,
and can be used to reset or regenerate the configuration script by the user.
}
