% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplhit2_core.R
\name{tcplhit2_core}
\alias{tcplhit2_core}
\title{Hitcalling Function}
\usage{
tcplhit2_core(
  params,
  conc,
  resp,
  cutoff,
  onesd,
  bmr_scale = 1.349,
  bmed = 0,
  conthits = TRUE,
  aicc = FALSE,
  identifiers = NULL,
  bmd_low_bnd = NULL,
  bmd_up_bnd = NULL
)
}
\arguments{
\item{params}{The output from tcplfit2_core}

\item{conc}{list of concentrations (not in log units)}

\item{resp}{list of corresponding responses}

\item{cutoff}{noise cutoff}

\item{onesd}{1 standard deviation of the noise (for bmd calculation)}

\item{bmr_scale}{bmr scaling factor. Default = 1.349}

\item{bmed}{median of noise estimate. Default 0}

\item{conthits}{conthits = TRUE uses continuous hitcalls, otherwise they're
discrete. Default TRUE}

\item{aicc}{aicc = TRUE uses corrected AIC to choose winning method; otherwise
regular AIC. Default FALSE}

\item{identifiers}{A one-row data frame containing identifiers of the concentration-response profile,
such as the chemical name or other identifiers, and any assay identifiers. The column names
identify the type of value. This can be NULL. The values will be included in the output
summary data frame}

\item{bmd_low_bnd}{Multiplier for bmd lower bound.  A value of .1 would require the bmd to be no lower
than 1/10th of the lowest concentration tested.}

\item{bmd_up_bnd}{Multiplier for the bmd upper bound.  A value of 10 would require the bmd to be no lower
than 10 times the highest concentration tested.}
}
\value{
A list of with the detailed results from all of the different model fits.
The elements of summary are:
  \itemize{
    \item any elements of the identifiers input
    \item n_gt_cutoff - number of data points above the cutoff
    \item cutoff - noise cutoff
    \item fit_method - curve fit method
    \item top_over_cutoff - top divided by cutoff
    \item rmse - RMSE of the data points around the best model curve
    \item a - fitting parameter methods: exp2, exp3, poly1, poly2, pow
    \item b - fitting parameter methods: exp2, exp3, ploy2
    \item p - fitting parameter methods: exp3, exp5, gnls, hill, pow
    \item q - fitting parameter methods: gnls,
    \item tp - top of the curve
    \item ga - ac50 for the rising curve in a gnls model or the Hill model
    \item la - ac50 for the falling curve in a gnls model
    \item er - fitted error term for plotting error bars
    \item bmr - benchmark response; level at which bmd is calculated = onesd*bmr_scale default bmr_scale is 1.349
    \item bmd - benchmark dose, curve value at bmr
    \item bmdl - lower limit on the bmd
    \item bmdu - upper limit on the bmd
    \item caikwt - one factor used in calculating the continuous hitcall. It is calcalated from the formula
      = exp(-aic(cnst)/2)/(exp(-aic(cnst)/2) + exp(-aic(fit_method)/2)) and measures how much lower the
      selected method AIC is than that for the constant model
    \item mll - another factor used in calcualting the continuous hitcall = length(modpars) - aic(fit_method)/2
    \item hitcall - the final hitcall, a value ranging from 0 to 1
    \item top - curve top
    \item ac50 - curve value at 50\% of top, curve value at cutoff
    \item lc50 - curve value at 50\% of top corresponding to the loss side of the gain-loss curve
    \item ac5 - curve value at 5\% of top
    \item ac10 - curve value at 10\% of top
    \item ac20 - curve value at 20\% of top
    \item acc - curve value at 1 standard deviation
    \item conc - conc string separated by |'s
    \item resp - response string separated by |'s
  }
}
\description{
Core of hitcalling function. This method chooses the winning model from tcplfit2_core,
extracts the top and ac50, computes the hitcall, and calculates bmd/bmdl/bmdu among other
statistics. Nested model selection is used to choose between poly1/poly2, then
the model with the lowest AIC (or AICc) is declared the winner. Continuous
hitcalls requires tcplfit2_core to be run with force.fit = TRUE and "cnst" never to
be chosen as the winner.
}
