% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.AUC.R
\name{calc.AUC}
\alias{calc.AUC}
\title{Calculate the area under a ROC curve (AUC)}
\usage{
calc.AUC(sens, spec)
}
\arguments{
\item{sens}{a numerical vector of sensitivity values within the range of (0, 1).}

\item{spec}{a numerical vector of specificity values within the range of (0, 1).}
}
\value{
AUC as a numerical scalar.
}
\description{
This function reads in a vector of sensitivity and a vector of specificity and calculates
the area under the curve (AUC) by trapezoidal integration.
}
\note{
This function sorts \code{sens} and \code{1-spec} in an increasing order.
     A 0 and 1 will be added to the two ends of the sorted vectors. The Area Under the Curve (AUC) is obtained by trapezoidal
      integration of the area under the piecewise linear curve obtained by connecting
       points in \code{sens} and \code{1-spec}. .
}
\examples{
sens <- c(0.99, 0.97, 0.83, 0.60, 0.40, 0.20) ;
spec <- c(0.50, 0.61, 0.80, 0.90, 0.95, 0.98) ;
plot( 1-spec, sens, type = "l" ) ;
points(1-spec, sens) ;
calc.AUC( sens, spec ) ;

}

