% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.secondly}
\alias{f.secondly}
\title{Create a \code{Second-ly} Frequency}
\usage{
f.secondly(day, second)
}
\arguments{
\item{day}{A 'Day-based' object of class \code{ldtf}, such as \code{Daily} or \code{Daily-In-Week}.}

\item{second}{The index of the second in the day, which should be between 1 and 86400.}
}
\value{
An object of class \code{ldtf}. It is also a list with the following members:
\item{class}{Determines the class of this frequency.}
\item{day}{Determines the \code{day}.}
\item{second}{Determines the \code{second}.}
}
\description{
Use this function to create a frequency for time-series data that occurs every second in a day or a subset of a week.
}
\details{
In order to use the \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format}: \code{"YYYYMMDD:#"} (where # represents the value of \code{second})
\item \strong{Class Id}: \code{se|...} (where '...' represents the 'class id' of \code{day})
}
}
\examples{

se0 <- f.secondly(f.daily(c(2023,5,16)),40032)

se0_value_str <-  as.character(se0) # this will be '20230516:40032'.
se0_class_str <- get.class.id(se0)
#     this will be 'se|d'. The second part (i.e., 'd') shows
#     that this frequency is defined in a 'Daily' frequency.

se_new <- as.frequency("20231101:3", "se|i:wed-sat")

# Don't make the following mistakes:
\donttest{
mi_invalid <- try(as.frequency("20231101:3", "se|j:wed-sat"))
#  invalid format in day-based frequency
mi_invalid <- try(f.secondly(f.daily(c(2023,5,16)),100000)) # invalid second
}

}
