% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Smallest Extreme Value}
\alias{Smallest Extreme Value}
\alias{qsev}
\alias{psev}
\alias{dsev}
\alias{rsev}
\alias{ssev}
\title{The Smallest Extreme Value Distribution}
\usage{
qsev(p, loc = 0, scale = 1)

psev(q, loc = 0, scale = 1)

dsev(x, loc = 0, scale = 1)

rsev(n, loc = 0, scale = 1)

ssev(x, loc = 0, scale = 1)
}
\arguments{
\item{p}{Vector of probabilities}

\item{loc}{Location parameter}

\item{scale}{Scale parameter}

\item{q}{Vector of quantiles}

\item{x}{Vector of quantiles}

\item{n}{Number of observations}
}
\value{
\code{dsev} gives the density, 
        \code{psev} gives the distribution function, 
        \code{qsev} gives the quantile function, and 
        \code{rsev} generates random observations.
        
        The length of the result is determined by \code{n} 
        for \code{rsev}, and is the maximum of the lengths 
        of the numerical arguments for the other functions. 
        
        The numerical arguments other than \code{n} are 
        recycled to the length of the result.
}
\description{
Density, distribution function, quantile function and 
             random generation for the SEV distribution with location
             \code{loc} and scale \code{scale}.
}
\details{
If \code{loc} is not specified, a default 
         value of 0 is used. If \code{scale} is not 
         specified, a default value of 1 is used.
         
         The smallest extreme value distribution with 
         location parameter \eqn{\mu} and
         scale \eqn{\sigma} has density
         
         \deqn{f(x;\mu,\sigma) = \frac{1}{\sigma}\phi_{_{SEV}}\left(\frac{x-\mu}{\sigma}\right),\quad -\infty < x < \infty }
         
         where \eqn{\phi_{_{SEV}}(z)} exp[z - exp(z)] is the density of the standard LEV distribution.
}
