app_driver_tm_g_bivariate <- function() {
  data <- teal.data::teal_data()
  data <- within(data, {
    require(nestcolor)
    CO2 <- data.frame(CO2) # nolint: object_name.
  })

  init_teal_app_driver(
    data = data,
    modules = tm_g_bivariate(
      x = teal.transform::data_extract_spec(
        dataname = "CO2",
        select = teal.transform::select_spec(
          label = "Select variable:",
          choices = teal.transform::variable_choices(data[["CO2"]]),
          selected = "conc",
          fixed = FALSE
        )
      ),
      y = teal.transform::data_extract_spec(
        dataname = "CO2",
        select = teal.transform::select_spec(
          label = "Select variable:",
          choices = teal.transform::variable_choices(data[["CO2"]]),
          selected = "uptake",
          multiple = FALSE,
          fixed = FALSE
        )
      ),
      row_facet = teal.transform::data_extract_spec(
        dataname = "CO2",
        select = teal.transform::select_spec(
          label = "Select variable:",
          choices = teal.transform::variable_choices(data[["CO2"]]),
          selected = "Type",
          fixed = FALSE
        )
      ),
      col_facet = teal.transform::data_extract_spec(
        dataname = "CO2",
        select = teal.transform::select_spec(
          label = "Select variable:",
          choices = teal.transform::variable_choices(data[["CO2"]]),
          selected = "Treatment",
          fixed = FALSE
        )
      ),
      color = teal.transform::data_extract_spec(
        dataname = "CO2",
        select = teal.transform::select_spec(
          label = "Select variable:",
          choices = teal.transform::variable_choices(data[["CO2"]], c("Plant", "Type", "Treatment")),
          selected = "Treatment",
          fixed = FALSE
        )
      ),
      fill = teal.transform::data_extract_spec(
        dataname = "CO2",
        select = teal.transform::select_spec(
          label = "Select variable:",
          choices = teal.transform::variable_choices(data[["CO2"]], c("Plant", "Type", "Treatment")),
          selected = "Treatment",
          fixed = FALSE
        )
      ),
      size = teal.transform::data_extract_spec(
        dataname = "CO2",
        select = teal.transform::select_spec(
          label = "Select variable:",
          choices = teal.transform::variable_choices(data[["CO2"]], c("Plant", "Type", "Treatment")),
          selected = "Treatment",
          fixed = FALSE
        )
      ),
      color_settings = TRUE,
      free_x_scales = FALSE,
      free_y_scales = TRUE,
      ggplot2_args = teal.widgets::ggplot2_args(
        labs = list(subtitle = "Plot generated by Bivariate Module")
      ),
      ggtheme = "classic",
      swap_axes = TRUE
    )
  )
}

testthat::test_that("e2e - tm_g_bivariate: Module is initialised with the specified defaults.", {
  testthat::skip("chromium")
  skip_if_too_deep(5)

  app_driver <- app_driver_tm_g_bivariate()

  app_driver$expect_no_shiny_error()

  testthat::expect_equal(app_driver$get_active_module_input("x-dataset_CO2_singleextract-select"), "conc")
  testthat::expect_equal(app_driver$get_active_module_input("y-dataset_CO2_singleextract-select"), "uptake")
  testthat::expect_true(app_driver$get_active_module_input("facetting"))
  testthat::expect_equal(app_driver$get_active_module_input("row_facet-dataset_CO2_singleextract-select"), "Type")
  testthat::expect_equal(app_driver$get_active_module_input("col_facet-dataset_CO2_singleextract-select"), "Treatment")
  testthat::expect_true(app_driver$get_active_module_input("coloring"))
  testthat::expect_equal(app_driver$get_active_module_input("color-dataset_CO2_singleextract-select"), "Treatment")
  testthat::expect_equal(app_driver$get_active_module_input("size-dataset_CO2_singleextract-select"), "Treatment")
  testthat::expect_equal(app_driver$get_active_module_input("fill-dataset_CO2_singleextract-select"), "Treatment")
  testthat::expect_false(app_driver$get_active_module_input("free_x_scales"))
  testthat::expect_true(app_driver$get_active_module_input("free_y_scales"))
  testthat::expect_false(app_driver$get_active_module_input("rotate_xaxis_labels"))
  testthat::expect_true(app_driver$get_active_module_input("swap_axes"))
  testthat::expect_equal(app_driver$get_active_module_input("ggtheme"), "classic")
  testthat::expect_equal(app_driver$get_active_module_input("alpha"), 0.5)
  testthat::expect_equal(app_driver$get_active_module_input("fixed_size"), 2)
  testthat::expect_false(app_driver$get_active_module_input("add_lines"))

  app_driver$stop()
})

testthat::test_that("e2e - tm_g_bivariate: Coloring options are hidden when coloring is toggled off.", {
  testthat::skip("chromium")
  skip_if_too_deep(5)
  app_driver <- app_driver_tm_g_bivariate()

  testthat::expect_true(
    app_driver$is_visible(
      app_driver$active_module_element("color-dataset_CO2_singleextract-select_input")
    )
  )
  testthat::expect_true(
    app_driver$is_visible(
      app_driver$active_module_element("size-dataset_CO2_singleextract-select_input")
    )
  )
  testthat::expect_true(
    app_driver$is_visible(
      app_driver$active_module_element("fill-dataset_CO2_singleextract-select_input")
    )
  )

  app_driver$set_active_module_input("coloring", FALSE)

  testthat::expect_false(
    app_driver$is_visible(
      app_driver$active_module_element("color-dataset_CO2_singleextract-select_input")
    )
  )
  testthat::expect_false(
    app_driver$is_visible(
      app_driver$active_module_element("size-dataset_CO2_singleextract-select_input")
    )
  )
  testthat::expect_false(
    app_driver$is_visible(
      app_driver$active_module_element("fill-dataset_CO2_singleextract-select_input")
    )
  )

  app_driver$stop()
})

testthat::test_that("e2e - tm_g_bivariate: Facetting options are hidden when facet is toggled off.", {
  testthat::skip("chromium")
  skip_if_too_deep(5)

  app_driver <- app_driver_tm_g_bivariate()

  testthat::expect_true(
    app_driver$is_visible(
      app_driver$active_module_element("row_facet-dataset_CO2_singleextract-select")
    )
  )
  testthat::expect_true(
    app_driver$is_visible(
      app_driver$active_module_element("col_facet-dataset_CO2_singleextract-select")
    )
  )
  testthat::expect_true(app_driver$is_visible(app_driver$active_module_element("free_x_scales")))
  testthat::expect_true(app_driver$is_visible(app_driver$active_module_element("free_y_scales")))

  app_driver$set_active_module_input("facetting", FALSE)

  testthat::expect_false(
    app_driver$is_visible(
      app_driver$active_module_element("row_facet-dataset_CO2_singleextract-select")
    )
  )
  testthat::expect_false(
    app_driver$is_visible(
      app_driver$active_module_element("col_facet-dataset_CO2_singleextract-select")
    )
  )
  testthat::expect_false(app_driver$is_visible(app_driver$active_module_element("free_x_scales")))
  testthat::expect_false(app_driver$is_visible(app_driver$active_module_element("free_y_scales")))

  app_driver$stop()
})

testthat::test_that("e2e - tm_g_bivariate: Setting encoding inputs produces outputs without validation errors.", {
  testthat::skip("chromium")
  skip_if_too_deep(5)

  app_driver <- app_driver_tm_g_bivariate()

  app_driver$set_active_module_input("alpha", 1)
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("fixed_size", 6)
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("add_lines", TRUE)
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("x-dataset_CO2_singleextract-select", "Plant")
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("y-dataset_CO2_singleextract-select", "conc")
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("row_facet-dataset_CO2_singleextract-select", "Plant")
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("col_facet-dataset_CO2_singleextract-select", "Type")
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("color-dataset_CO2_singleextract-select", "Type")
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("size-dataset_CO2_singleextract-select", "Type")
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("fill-dataset_CO2_singleextract-select", "Plant")
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("free_x_scales", TRUE)
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("free_y_scales", FALSE)
  app_driver$expect_no_validation_error()

  app_driver$set_active_module_input("rotate_xaxis_labels", TRUE)

  app_driver$set_active_module_input("swap_axes", TRUE)

  app_driver$set_active_module_input("ggtheme", "light")

  app_driver$stop()
})
