% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{PoR_distance}
\alias{PoR_distance}
\title{Distance to Pole of Rotation}
\usage{
PoR_distance(x, PoR, FUN = orthodrome)
}
\arguments{
\item{x}{\code{sf} or \code{data.frame} containing lat and lon coordinates
(\code{lat}, \code{lon})}

\item{PoR}{Pole of Rotation. \code{"data.frame"} or object of class \code{"euler.pole"}
containing the geographical coordinates of the Euler pole}

\item{FUN}{function to calculate the great-circle distance.
\code{\link[=orthodrome]{orthodrome()}}, \code{\link[=haversine]{haversine()}} (the default), or \code{\link[=vincenty]{vincenty()}}.}
}
\value{
numeric vector
}
\description{
Retrieve the (angular) distance to the PoR (Euler pole).
}
\examples{
data("nuvel1")
por <- subset(nuvel1, nuvel1$plate.rot == "na") # North America relative to Pacific plate
data("san_andreas")

# distance form sf object
PoR_distance(san_andreas, por)

# distance form data.frame
PoR_distance(sf::st_drop_geometry(san_andreas), por)
PoR_distance(sf::st_drop_geometry(san_andreas), por, FUN = orthodrome)
PoR_distance(sf::st_drop_geometry(san_andreas), por, FUN = vincenty)
}
