% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stLL.R
\name{stLL}
\alias{stLL}
\title{Compute log likelihood for model}
\usage{
stLL(stData, stFit, beta, sigmasq_y, sigmasq_r, sigmasq_eps, rho_y, rho_r,
  X = stData$X, Y = stData$Y, Z = stData$Z,
  coords.s = stData$coords.s, coords.r = stData$coords.r,
  coords.knots = stFit$coords.knots, miles = TRUE, sigmasq_r_eps)
}
\arguments{
\item{stData}{Object with class 'stData' containing data needed to fit this 
model. The data need only be manually entered if not using a stData object.}

\item{stFit}{Object with class 'stFit' containing posterior parameter samples
needed to composition sample the teleconnection effects and generate 
posterior predictions. The data needed from stFit need only be manually 
entered if not using a stData object.}

\item{beta}{values of \eqn{\beta} at which to evaluate the likelihood}

\item{sigmasq_y}{values of \eqn{\sigma^2_w} at which to evaluate the
likelihood}

\item{sigmasq_r}{values of \eqn{\sigma^2_\alpha} at which to evaluate the
likelihood}

\item{sigmasq_eps}{values of \eqn{\sigma^2_\varepsilon} at which to evaluate 
the likelihood}

\item{rho_y}{values of \eqn{\rho_w} at which to evaluate  the likelihood}

\item{rho_r}{values of \eqn{\rho_\alpha} at which to evaluate the likelihood}

\item{X}{[ns, p, nt] array of design matrices with local covariates}

\item{Y}{[ns, nt] matrix with response data}

\item{Z}{[nr, nt] matrix with remote covariates}

\item{coords.s}{matrix with coordinates where responses were 
observed (lon, lat)}

\item{coords.r}{matrix with coordinates where remote covariates
were observed (lon, lat)}

\item{coords.knots}{matrix with coordinates of knots for remote covariates
(lon, lat)}

\item{miles}{TRUE if distances should be computed in miles (kilometers otherwise)}

\item{sigmasq_r_eps}{values of \eqn{\sigma^2_{\alpha_\varepsilon}} at which 
to evaluate the likelihood}
}
\description{
Compute log likelihood for model
}
\examples{
library(dplyr)
library(foreach)
library(itertools)

set.seed(2018)

data("coprecip")
data("coprecip.fit")
attach(coprecip)

ests = coef(coprecip.fit, burn = 50)

ll = stLL(stData = coprecip, stFit = coprecip.fit, 
          beta = matrix(ests$beta, ncol = 2), 
          sigmasq_y = ests$sigmasq_y, sigmasq_r = ests$sigmasq_r, 
          sigmasq_eps = ests$sigmasq_eps,
          rho_y = ests$rho_y, rho_r = ests$rho_r, 
          sigmasq_r_eps = 0)
}
