% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teleCor.R
\name{teleCor}
\alias{teleCor}
\title{Pointwise correlations for an exploratory teleconnection analysis}
\usage{
teleCor(
  stData = NULL,
  Y = stData$Y,
  Z = stData$Z,
  coords.s = stData$coords.s,
  coords.r = stData$coords.r
)
}
\arguments{
\item{stData}{stData object containing data to analyze}

\item{Y}{[ny x nt] a matrix composed of \eqn{ny} row vectors, each of which 
contains \eqn{nt} observations fom a different spatial location.  Spatial 
locations for \code{Y} are indexed by \code{coords.s}.}

\item{Z}{[nz x nt] a matrix composed of \eqn{nz} row vectors each of which
contains \eqn{nt} observations from a different spatial location.  Spatial
locations for \code{Z} are indexed by \code{coords.r}.}

\item{coords.s}{coordinates of locations in Y}

\item{coords.r}{coordinates of locations in Z}
}
\value{
list with a matrix 'cor' containing correlations.  The columns index
  remote coordinates, while the rows index the local coordinates.  The 
  returned list also includes the coordinates.
}
\description{
Computes empirical correlations between rows of \code{Y} and \code{Z}, 
for use as exploratory analysis of teleconnection patterns between locations 
indexed by \code{coords.s} and \code{coords.r}.  Optionally, an \code{stData}
object containing \code{Y} and \code{Z} can be passed instead.
}
\examples{

data("coprecip")

cors = teleCor(coprecip)

}
