% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_alpha_e0.R
\name{priorOnAlpha_spec}
\alias{priorOnAlpha_spec}
\title{Specify prior on \eqn{\alpha}.}
\usage{
priorOnAlpha_spec(H = c("alpha_const", "gam_05_05", "gam_1_2", "F_6_3"))
}
\arguments{
\item{H}{A character indicating which specification should be used.}
}
\value{
A named list containing:
\itemize{
\item \code{"log_pAlpha"}: a function of the log prior of \eqn{\alpha}.
\item \code{"param"}: a list with the parameters.
}
}
\description{
Obtain a function to evaluate the log prior specified
for \eqn{\alpha}.
}
\details{
The following prior specifications are supported:
\itemize{
\item \code{"alpha_const"}: \eqn{\alpha} is fixed at 1.
\item \code{"gam_05_05"}: \eqn{\alpha \sim} gamma(0.5, 0.5), i.e., shape = 0.5, rate = 0.5.
\item \code{"gam_1_2"}: \eqn{\alpha \sim} gamma(1, 2), i.e., shape = 1, rate = 2.
\item \code{"F_6_3"}: \eqn{\alpha \sim} F(6, 3), i.e., an F-distribution with degrees of freedom equal to 6 and 3.
}
}
