% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_FCtemplateICA.R
\name{EM_FCtemplateICA}
\alias{EM_FCtemplateICA}
\title{EM Algorithm for FC Template ICA Model}
\usage{
EM_FCtemplateICA(
  template_mean,
  template_var,
  template_FC,
  prior_params = c(0.001, 0.001),
  BOLD,
  AS_0,
  maxiter = 100,
  epsilon = 0.01,
  verbose
)
}
\arguments{
\item{template_mean}{(\eqn{V \times Q} matrix) mean maps for each IC in template,
where \eqn{Q} is the number of ICs, \eqn{V=nvox} is the number of data locations.}

\item{template_var}{(\eqn{V \times Q} matrix) between-subject variance maps for each IC in template}

\item{template_FC}{(list) Parameters of functional connectivity template}

\item{prior_params}{Alpha and beta parameters of IG prior on tau^2 (error variance)}

\item{BOLD}{(\eqn{V \times T} matrix) preprocessed fMRI data}

\item{AS_0}{(list) initial guess at latent variables: A (\eqn{TxQ} mixing matrix),
and S (\eqn{QxV} matrix of spatial ICs)}

\item{maxiter}{Maximum number of EM iterations. Default: 100.}

\item{epsilon}{Smallest proportion change in parameter estimates between iterations. Default: 0.01.}

\item{verbose}{If \code{TRUE}, display progress of algorithm. Default: \code{FALSE}.}
}
\value{
A list:
theta (list of final parameter estimates),
subICmean (estimates of subject-level ICs),
subICvar (variance of subject-level ICs),
mixing_mean (estimates of subject-level mixing matrix),
mixing_var (variance of subject-level mixing matrix),
success (flag indicating convergence (\code{TRUE}) or not (\code{FALSE}))
}
\description{
EM Algorithm for FC Template ICA Model
}
\details{
\code{EM_FCtemplateICA} implements the expectation-maximization
(EM) algorithm for the functional connectivity (FC) template ICA model
}
