% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VB_FCtemplateICA.R
\name{update_A_Chol}
\alias{update_A_Chol}
\title{Update A for VB FC Template ICA using Cholesky prior for FC}
\usage{
update_A_Chol(
  mu_tau2,
  mu_S,
  E_SSt,
  BOLD,
  ntime,
  nICs,
  nvox,
  template_FC,
  final = FALSE,
  exact = FALSE,
  usePar = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{mu_tau2, mu_S, E_SSt}{Most recent estimates of posterior
moments for these variables.}

\item{BOLD}{(\eqn{T \times V} matrix) preprocessed fMRI data.}

\item{ntime, nICs, nvox}{Number of timepoints, number of ICs, number of locations}

\item{template_FC}{IW parameters for FC template}

\item{final}{If TRUE, return cov_A. Default: \code{FALSE}}

\item{exact}{If FALSE, at intermediate steps (final = \code{FALSE}) will attempt to
approximate V_k as described in the appendix of Mejia et al. 2024. Setting
\code{exact = TRUE} may be helpful when using spatial ESS correction,
which can lead to a lower rate of usable prior samples for the approximation.}

\item{usePar}{Parallelize the computation? Default: \code{FALSE}. Can be the
number of cores to use or \code{TRUE}, which will use the number available minus two.}

\item{verbose}{If \code{TRUE}, display progress of algorithm. Default: \code{FALSE}.}
}
\value{
List of length two: \code{mu_A} (TxQ) and \code{E_AtA} (QxQ).
}
\description{
Update A for VB FC Template ICA using Cholesky prior for FC
}
\keyword{internal}
