% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asktell.R
\name{tell_Y}
\alias{tell_Y}
\title{ask&tell component function to 'tell' objective function value to waiting 'ask_Y' call in another R session.}
\usage{
tell_Y(
  y,
  id = 0,
  Y.tmp = "Y.done",
  tmp_path = file.path(tempdir(), "..", "asktell.tmp"),
  trace = function(...) cat(paste0(..., "\\n")),
  force_cleanup = FALSE
)
}
\arguments{
\item{y}{output value of objective function to return}

\item{id}{unique identifier for this asktell loop (default: "0")}

\item{Y.tmp}{temporary "Y" values file (default: "Y.done")}

\item{tmp_path}{temporary directory to store X.tmp & Y.tmp (default: 'tempdir()/../asktell.tmp')}

\item{trace}{function to display asktell loop status (default : 'cat')}

\item{force_cleanup}{should we cleanup temporary files before writing (possible conflicting asktell calls) ? (default: FALSE)}
}
\value{
input value of objective function to compute externally
}
\description{
ask&tell component function to 'tell' objective function value to waiting 'ask_Y' call in another R session.
}
\details{
'ask&tell' injection loop to call an external objective function within an inline algorithm (like optim(...))
Main idea: pass 'ask_Y' as objectve function argument of algorithm, which will wait until you call 'tell_Y' in another R process.
In this secondary process, you can read what X is called using 'ask_X', and when you know what values returns from the external objective, 
just call 'tell_Y' to give it.
}
\examples{
\dontrun{ ### Assumes you can use two independant R sessions
## In main R session
  ask_Y(x=123)
## In another R session
  ask_X() # returns 123
  tell_Y(y=456)
## Then ask_dY in main R session returns with value '456'
}
}
\author{
Y. Richet, discussions with D. Sinoquet. Async IO principle was defined by G. Pujol.
}
