% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_gen.R
\name{tensor_gen}
\alias{tensor_gen}
\title{Data generation of tensor time series with factor structure}
\usage{
tensor_gen(
  K,
  TT,
  d,
  r,
  re,
  eta,
  coef_f,
  coef_fe,
  coef_e,
  heavy_tailed = FALSE,
  t_df = 3,
  seed = 2023
)
}
\arguments{
\item{K}{Order of the generated tensor at each time t.}

\item{TT}{Length of time series.}

\item{d}{Dimensions of each mode of the tensor, written in a vector of length K.}

\item{r}{Rank of the core tensors, written in a vector of length K.}

\item{re}{Rank of the cross-sectional common error core tensors, written in a vector of length K.}

\item{eta}{Quantities controlling factor strengths in each factor loading matrix, written in a list of K vectors.}

\item{coef_f}{AR(5) coefficients for the factor series, written in a vector of length 5.}

\item{coef_fe}{AR(5) coefficients for the common component in error series, written in a vector of length 5.}

\item{coef_e}{AR(5) coefficients for the idiosyncratic component in error series, written in a vector of length 5.}

\item{heavy_tailed}{Whether to generate data from heavy-tailed distribution. If FALSE, generate from N(0,1); if TRUE, generate from t-distribution. Default is FALSE.}

\item{t_df}{The degree of freedom for t-distribution if heavy_tailed = TRUE. Default is 3.}

\item{seed}{Random seed required for reproducibility. Default is 2023.}
}
\value{
A list containing the following:
X: the generated tensor time series, as multi-dimensional array with dimension K+1, where mode-1 is the time mode;
A: a list of K factor loading matrices;
C: the generated common component time series, as multi-dimensional array with dimension K+1, where mode-1 is the time mode;
Ft: the generated core factor series, as multi-dimensional array with dimension K+1, where mode-1 is the time mode;
}
\description{
Generate an order-K tensor at each time t, with the first mode as the time mode and maximum allowed K is 4
}
\examples{
K = 3;
TT = 10;
d = c(20,20,20);
r = c(2,2,2);
re = c(2,2,2);
eta = list(c(0,0), c(0,0), c(0,0));
coef_f = c(0.7, 0.3, -0.4, 0.2, -0.1);
coef_fe = c(-0.7, -0.3, -0.4, 0.2, 0.1);
coef_e = c(0.8, 0.4, -0.4, 0.2, -0.1);
tensor_gen(K,TT,d,r,re,eta, coef_f, coef_fe, coef_e);



}
