% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfunction.R
\name{estimation}
\alias{estimation}
\title{Estimation of tensor entries from the cumulative model}
\usage{
estimation(theta,omega,type = c("mode","mean","median"))
}
\arguments{
\item{theta}{a continuous-valued tensor (latent parameters)}

\item{omega}{the cut-off points}

\item{type}{type of estimations:

\code{"mode"} specifies argmax based label estimation

\code{"mean"} specifies mean based label estimation

\code{"median"} specifies median based label estimation}
}
\value{
an estimated ordinal tensor given latent parameters and a type of estimations
}
\description{
Estimate the ordinal-valued tensor entries given latent parameters and a type of estimations
}
\examples{
indices <- c(10,20,30)
arr <- array(runif(prod(indices),-2,2),dim = indices)
b <- c(-1.5,0,1.5)
r_predict <- estimation(arr,b,type = "mode");r_predict
}
\references{
Lee, C., & Wang, M. (2020). Tensor denoising and completion based on ordinal observations. \emph{arXiv preprint arXiv:2002.06524}.
}
