% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sptensor-extract-dimnames.r,
%   R/sptensor-extract.r
\docType{methods}
\name{[,sptensor,character,missing,ANY-method}
\alias{[,sptensor,character,missing,ANY-method}
\alias{[,sptensor,numeric,missing-method}
\alias{[,sptensor,missing,character,ANY-method}
\alias{[,sptensor,missing,numeric-method}
\alias{[,sptensor,character,character,ANY-method}
\alias{[,sptensor,numeric,numeric-method}
\alias{sptensor-extract}
\alias{[,sptensor,missing,missing,ANY-method}
\alias{[,sptensor,missing,missing-method}
\alias{[,sptensor,numeric,missing,ANY-method}
\alias{[,sptensor,missing,numeric,ANY-method}
\alias{[,sptensor,numeric,numeric,ANY-method}
\alias{[,sptensor,list,missing,ANY-method}
\alias{[,sptensor,list,missing-method}
\alias{[,sptensor,matrix,missing,ANY-method}
\alias{[,sptensor,matrix,missing-method}
\title{Extract values from a sparse tensor}
\usage{
\S4method{[}{sptensor,character,missing,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{sptensor,missing,character,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{sptensor,character,character,ANY}(x, i, j, ...,
  drop = FALSE)

\S4method{[}{sptensor,missing,missing,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{sptensor,numeric,missing,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{sptensor,missing,numeric,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{sptensor,numeric,numeric,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{sptensor,list,missing,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{sptensor,matrix,missing,ANY}(x, i, j, ..., drop = FALSE)
}
\arguments{
\item{x}{sptensor object}

\item{i}{numeric index, vector, list, or matrix}

\item{j}{numeric index}

\item{...}{additional numeric indices}

\item{drop}{whether to drop dimensions}
}
\description{
There are multiple ways to provide indices for a sparse tensor. For example,
if you have a three-dimensional tensor you can provide indices separated
by a comma or a numeric vector of linear indices:
\itemize{
\item{c(x[1,1,1], x[1,1,2])}
\item{x[c(1, 5)]}
}
However for tensors with high dimensions this can be cumbersome to write.
Therefore the \code{tensor} class also allows you to extract values with
indices in matrix or list form, which are more suited for non-interactive
coding.
\itemize{
\item{x[matrix(c(1,1,1,1,1,2), nrow = 3)]}
\item{x[list(c(1,1,1), c(1,1,2))]}
}
}
