% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.chooseLambda.R
\name{sim.chooseLambda}
\alias{sim.chooseLambda}
\title{Perform simulation: selecting the lambda}
\usage{
sim.chooseLambda(n, p, q, k, r, l, sparse, iteration, lambda,
  standarddeviation = 4, center = FALSE, method = "L0")
}
\arguments{
\item{n}{the dimension of mode 1}

\item{p}{the dimension of mode 2}

\item{q}{the dimension of mode 3}

\item{k}{\eqn{d_1}: the clusters number of mode 1}

\item{r}{\eqn{d_2}: the clusters number of mode 2}

\item{l}{\eqn{d_3}: the clusters number of mode 3}

\item{sparse}{the sparse percent of data}

\item{iteration}{iteration times}

\item{lambda}{a vector of possible lambda, for example: lambda = c(0,50,100,200,300,400,500,600,700,800,900,1000,1100,1200)}

\item{standarddeviation}{the standard deviation when producing data}

\item{center}{if True, then x = x- mean(x)}

\item{method}{two options: "L0", "L1". Two methods use different penalties, where "L0" indicating L0 penalty and "L1" indicating Lasso penalty.}
}
\value{
\code{selectedlambda}: a vector of selecting lambdas with lowest BIC in each iteration.
}
\description{
Simulation: selecting the lambda.  Select the lambda with lowest BIC while given a certain range.
}
