% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_tensor.R
\name{amprod}
\alias{amprod}
\title{\eqn{k}-mode product.}
\usage{
amprod(A, M, k)
}
\arguments{
\item{A}{A real valued array.}

\item{M}{A real matrix.}

\item{k}{An integer. The mode along which \code{M} is to be
multiplied to \code{A}.}
}
\value{
An array whose \eqn{k}-mode unfolding is \code{M \%*\%
    mat(A,k)}.
}
\description{
\code{amprod} returns the \eqn{k}-mode product of an array with a
matrix.
}
\details{
The \eqn{k}-mode product of a tensor \eqn{A} with a matrix \eqn{M}
results in a tensor whose \eqn{k}-mode unfolding is \eqn{M} times
the \eqn{k}-mode unfolding of \eqn{A}. That is
\code{mat(amprod(A,M,k)) = M \%*\% mat(A,k)}.  More details of the
\eqn{k}-mode product can be found in
\href{https://doi.org/10.1137/07070111X}{ Kolda and
Bader (2009)}.
}
\examples{
A <- array(1:8, dim = c(2,2,2))
M <- matrix(1:4, nrow = 2, ncol = 2)
Y <- amprod(A, M, 2)
Y
identical(M \%*\% mat(A,2), mat(Y,2))
}
\references{
Kolda, T. G., & Bader, B. W. (2009).
  \href{https://doi.org/10.1137/07070111X}{Tensor
  decompositions and applications}. \emph{SIAM review}, 51(3), 455-500.
}
\seealso{
\code{\link{atrans}} for applying multiple \eqn{k}-mode
    products.
}
\author{
Peter Hoff.
}
